/*
 * Decompiled with CFR 0.152.
 */
package be.appfoundry.progressbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import be.appfoundry.progressbutton.R;
import be.appfoundry.progressbutton.util.LayoutUtil;

public class ProgressButton
extends View {
    private int color;
    private int strokeColor;
    private int progressColor;
    private float strokeWidth;
    private float maxProgress = 100.0f;
    private float animationStep = 1.0f;
    private boolean isIndeterminate = true;
    private boolean reverse = false;
    private Drawable icon;
    private float radius;
    private float progress;
    private boolean isAnimating = false;
    private float startDegrees = 270.0f;
    private int animationDelay = 0;
    private boolean indeterminate;
    private Paint circlePaint = new Paint();
    private Paint progressPaint = new Paint();
    private Paint strokePaint = new Paint();
    private float degrees;
    private Handler animationHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (ProgressButton.this.isAnimating) {
                ProgressButton.this.handleAnimation();
            }
        }
    };
    RectF buttonRectF = new RectF();
    Rect iconRect = new Rect();

    public ProgressButton(Context context) {
        this(context, null);
        this.init(context, null);
    }

    public ProgressButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.init(context, attrs);
    }

    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.circlePaint = new Paint(1);
        this.progressPaint = new Paint(1);
        this.strokePaint = new Paint(1);
        TypedArray attr = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressButton, 0, 0);
        try {
            this.color = attr.getColor(R.styleable.ProgressButton_fillColor, -1);
            this.circlePaint.setColor(this.color);
            this.strokeColor = attr.getColor(R.styleable.ProgressButton_strokeColor, -1);
            this.strokePaint.setColor(this.strokeColor);
            this.progressColor = attr.getColor(R.styleable.ProgressButton_progressColor, -1);
            this.progressPaint.setColor(this.progressColor);
            this.strokeWidth = attr.getDimension(R.styleable.ProgressButton_strokeWidth, 0.0f);
            this.isIndeterminate = attr.getBoolean(R.styleable.ProgressButton_indeterminate, true);
            this.icon = attr.getDrawable(R.styleable.ProgressButton_progressIcon);
        }
        finally {
            attr.recycle();
        }
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.degrees = 360.0f * progress / this.maxProgress;
        this.invalidate();
    }

    public float getStartDegrees() {
        return this.startDegrees;
    }

    public void setStartDegrees(float degrees) {
        this.startDegrees = degrees;
        this.invalidate();
    }

    public void setProgressStart(float progress, float startDegrees) {
        this.progress = progress;
        this.startDegrees = startDegrees;
        this.degrees = 360.0f * progress / this.maxProgress;
        this.invalidate();
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public void setIcon(Drawable icon) {
        this.icon = icon;
        this.invalidate();
    }

    public float getAnimationStep() {
        return this.animationStep;
    }

    public void setAnimationStep(float animationStep) {
        this.animationStep = animationStep;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
        this.requestLayout();
    }

    public float getStroke() {
        return this.strokeWidth;
    }

    public void setStroke(float stroke) {
        this.strokeWidth = stroke;
        this.invalidate();
        this.requestLayout();
    }

    public float getDegrees() {
        return this.degrees;
    }

    public void setDegrees(float degrees) {
        this.degrees = degrees;
        this.invalidate();
        this.requestLayout();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.circlePaint.setColor(color);
        this.invalidate();
        this.requestLayout();
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
        this.requestLayout();
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
        this.progressPaint.setColor(progressColor);
        this.invalidate();
        this.requestLayout();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.invalidate();
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size;
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        int width = this.getLayoutParams().width;
        int height = this.getLayoutParams().height;
        int get_width = this.getWidth();
        int get_height = this.getHeight();
        int resolved_width = ProgressButton.resolveSize((int)get_width, (int)widthMeasureSpec);
        int resolved_height = ProgressButton.resolveSize((int)get_height, (int)heightMeasureSpec);
        if (this.radius > 0.0f) {
            size = (int)(this.radius * 2.0f);
        } else if (this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1) {
            size = resolved_width;
            if (size > resolved_height) {
                size = resolved_height;
            }
        } else if (this.getLayoutParams().width == -1 && this.getLayoutParams().height != -1) {
            size = resolved_height;
        } else if (this.getLayoutParams().height == -1 && this.getLayoutParams().width != -1) {
            size = resolved_width;
        } else if (this.getLayoutParams().width == -2 && this.getLayoutParams().height == -2) {
            size = (int)LayoutUtil.convertDpToPixel(this.getContext(), 48.0f);
        } else if (this.getLayoutParams().width == -2 && this.getLayoutParams().height != -2) {
            size = resolved_height;
        } else if (this.getLayoutParams().height == -2 && this.getLayoutParams().width != -2) {
            size = resolved_width;
        } else if (width > height) {
            size = resolved_height;
        } else if (width < height) {
            size = resolved_width;
        } else if (resolved_height == 0) {
            size = width;
            if (size > resolved_width) {
                size = resolved_width;
            }
        } else if (resolved_width == 0) {
            size = height;
            if (size > resolved_height) {
                size = resolved_height;
            }
        } else {
            size = resolved_width;
            if (size > resolved_height) {
                size = resolved_height;
            }
        }
        this.setMeasuredDimension(size, size);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.radius == 0.0f) {
            this.radius = this.getWidth() / 2;
        }
        float left = (float)(this.getWidth() / 2) - this.radius;
        float right = (float)(this.getWidth() / 2) + this.radius;
        float top = (float)(this.getHeight() / 2) - this.radius;
        float bottom = (float)(this.getHeight() / 2) + this.radius;
        this.buttonRectF.set(left, top, right, bottom);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius, this.strokePaint);
        canvas.drawArc(this.buttonRectF, this.startDegrees, this.degrees, true, this.progressPaint);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius - this.strokeWidth, this.circlePaint);
        if (this.icon != null) {
            this.iconRect.set(0, 0, (int)this.radius, (int)this.radius);
            this.iconRect.offset((this.getWidth() - (int)this.radius) / 2, (this.getHeight() - (int)this.radius) / 2);
            this.icon.setBounds(this.iconRect);
            this.icon.draw(canvas);
        }
    }

    public void startAnimating() {
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.animationHandler.sendEmptyMessage(0);
        }
    }

    public void stopAnimating() {
        if (this.isAnimating) {
            this.animationHandler.removeMessages(0);
            this.progress = 0.0f;
            this.reverse = false;
            this.startDegrees = 270.0f;
            this.setProgressStart(this.progress, this.startDegrees);
            this.isAnimating = false;
            this.invalidate();
        }
    }

    private void handleAnimation() {
        if (this.isIndeterminate) {
            if (this.progress >= this.maxProgress) {
                this.reverse = true;
                this.progress = this.maxProgress;
                this.startDegrees = 270.0f;
            } else if (this.progress <= 0.0f) {
                this.reverse = false;
                this.progress = 0.0f;
                this.startDegrees = 270.0f;
            }
            if (this.reverse) {
                float degrees1 = 360.0f * this.progress / this.maxProgress;
                this.progress -= this.animationStep;
                float degrees2 = 360.0f * this.progress / this.maxProgress;
                float diff = degrees1 - degrees2;
                this.startDegrees += diff;
            } else {
                this.progress += this.animationStep;
            }
        }
        this.setProgressStart(this.progress, this.startDegrees);
        this.animationHandler.sendEmptyMessageDelayed(0, (long)this.animationDelay);
    }
}

