/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.Version;

public class VersionTestCase
extends TestCase {
    public VersionTestCase(String name) {
        super(name);
    }

    public void testValidVersionString() {
        Version v1 = Version.getVersion("1");
        Assert.assertTrue((boolean)new Version(1, 0, 0).equals(v1));
        Version v2 = Version.getVersion("0.3");
        Assert.assertTrue((boolean)new Version(0, 3, 0).equals(v2));
        Version v3 = Version.getVersion("78.10.03");
        Assert.assertTrue((boolean)new Version(78, 10, 3).equals(v3));
    }

    public void testInvalidVersionString() {
        try {
            Version.getVersion("");
            Assert.fail((String)"Empty string is illegal version string");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            Version.getVersion("1.F");
            Version.getVersion("1.0-dev");
            Assert.fail((String)"Version string do contains only '.' and number");
        }
        catch (NumberFormatException nfe) {}
    }

    public void testComplies() {
        Version v1 = new Version(1, 3, 6);
        Version v2 = new Version(1, 3, 7);
        Version v3 = new Version(1, 4, 0);
        Version v4 = new Version(2, 0, 1);
        Assert.assertTrue((boolean)v1.complies(v1));
        Assert.assertTrue((!v1.complies(v2) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v2.complies(v1));
        Assert.assertTrue((!v1.complies(v3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v3.complies(v1));
        Assert.assertTrue((!v1.complies(v4) ? 1 : 0) != 0);
        Assert.assertTrue((!v4.complies(v1) ? 1 : 0) != 0);
    }
}

