/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.trees;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import at.amartinz.universaldebug.trees.BaseTree;
import at.amartinz.universaldebug.trees.BaseTreeComponent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import timber.log.Timber;

public class WriterComponent
extends BaseTreeComponent {
    private final File logDirectory;
    private final File logFile;

    public WriterComponent(@NonNull BaseTree baseTree) {
        this(baseTree, false);
    }

    public WriterComponent(@NonNull BaseTree baseTree, @Nullable File logDirectory) {
        super(baseTree);
        Context applicationContext = baseTree.getApplicationContext();
        Pair<File, File> logFilePair = this.sanitizeFileDirectories(applicationContext, logDirectory);
        this.logDirectory = (File)logFilePair.first;
        this.logFile = (File)logFilePair.second;
    }

    public WriterComponent(@NonNull BaseTree baseTree, boolean saveOnExternalStorage) {
        super(baseTree);
        Context applicationContext = baseTree.getApplicationContext();
        File logDir = null;
        if (saveOnExternalStorage) {
            logDir = applicationContext.getExternalFilesDir(null);
        }
        if (logDir == null) {
            logDir = applicationContext.getFilesDir();
        }
        Pair<File, File> logFilePair = this.sanitizeFileDirectories(applicationContext, logDir);
        this.logDirectory = (File)logFilePair.first;
        this.logFile = (File)logFilePair.second;
    }

    private String generateFileName(Context applicationContext) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH);
        Date date = new Date();
        String currentTime = sdf.format(date);
        return String.format("log_%s_%s.txt", applicationContext.getPackageName(), currentTime);
    }

    private Pair<File, File> sanitizeFileDirectories(Context applicationContext, @Nullable File logDirectory) {
        File dir = logDirectory != null && logDirectory.exists() && logDirectory.canRead() && logDirectory.canWrite() ? logDirectory : applicationContext.getFilesDir();
        File file = new File(dir, this.generateFileName(applicationContext));
        if (!file.exists()) {
            try {
                Timber.d((String)"Creating %s -> %s", (Object[])new Object[]{file, file.createNewFile()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Pair((Object)dir, (Object)file);
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public File getLogFile() {
        return this.logFile;
    }

    @Override
    protected void doLog(final int priority, final String tag, final String message, final Throwable t) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                WriterComponent.this.writeLogToFile(priority, tag, message, t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogToFile(int priority, String tag, String message, Throwable t) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.logFile, true);
            fileWriter.write(String.format("%s/%s: %s\n", BaseTree.mapPriorityToString(priority), tag, message));
            fileWriter.flush();
        }
        catch (IOException ioe) {
            this.baseTree.reallyDoLog(priority, tag, "Could not write log to file!", ioe);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

