/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.trees;

import android.content.Context;
import android.os.Vibrator;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import at.amartinz.universaldebug.trees.BaseTree;
import at.amartinz.universaldebug.trees.BaseTreeComponent;

public class VibrationComponent
extends BaseTreeComponent {
    public static final long DEFAULT_DURATION = 75L;
    private final Vibrator vibrator;
    private final long duration;

    @RequiresPermission(value="android.permission.VIBRATE")
    public VibrationComponent(@NonNull BaseTree baseTree) {
        this(baseTree, 75L);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public VibrationComponent(@NonNull BaseTree baseTree, long duration) {
        this(baseTree, duration, null);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public VibrationComponent(@NonNull BaseTree baseTree, long duration, @Nullable Vibrator vibrator) {
        super(baseTree);
        Context context;
        Object vibratorObject;
        this.duration = duration;
        this.vibrator = vibrator == null ? ((vibratorObject = (context = baseTree.getApplicationContext()).getSystemService("vibrator")) instanceof Vibrator && ((Vibrator)vibratorObject).hasVibrator() ? (Vibrator)vibratorObject : null) : null;
    }

    @Override
    protected void doLog(int priority, String tag, String message, Throwable t) {
        if (this.vibrator != null) {
            this.vibrator.cancel();
            this.vibrator.vibrate(this.duration);
        }
    }
}

