/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.trees;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import at.amartinz.universaldebug.trees.BaseTree;
import at.amartinz.universaldebug.trees.BaseTreeComponent;

public abstract class CrashComponent
extends BaseTreeComponent {
    public static final String DEFAULT_PREFIX_CRASH = "CRASH: ";
    protected String crashPrefix;

    public CrashComponent(@NonNull BaseTree baseTree) {
        this(baseTree, DEFAULT_PREFIX_CRASH);
    }

    public CrashComponent(@NonNull BaseTree baseTree, @NonNull String crashPrefix) {
        super(baseTree);
        this.crashPrefix = crashPrefix;
    }

    public CrashComponent setCrashPrefix(@NonNull String crashPrefix) {
        this.crashPrefix = crashPrefix;
        return this;
    }

    @Override
    protected boolean shouldLog(int priority) {
        return priority == 6;
    }

    protected boolean matchMessage(@Nullable String message) {
        return message != null && message.startsWith(this.crashPrefix);
    }

    @NonNull
    protected String extractFromMessage(@NonNull String message) {
        return message.replaceFirst(this.crashPrefix, "");
    }

    protected abstract void reportCrash(int var1, String var2, String var3, Throwable var4);

    @Override
    protected void doLog(int priority, String tag, String message, Throwable t) {
        if (!this.matchMessage(message)) {
            return;
        }
        message = this.extractFromMessage(message);
        this.reportCrash(priority, tag, message, t);
    }
}

