/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.trees;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import at.amartinz.universaldebug.trees.BaseTree;
import java.util.HashSet;

public abstract class BaseTreeComponent {
    protected BaseTree baseTree;
    protected HashSet<Integer> priorityFilterSet;

    public BaseTreeComponent(@NonNull BaseTree baseTree) {
        this.baseTree = baseTree;
    }

    protected abstract void doLog(int var1, String var2, String var3, Throwable var4);

    protected void log(int priority, String tag, String message, Throwable t) {
        if (this.shouldLog(priority)) {
            this.doLog(priority, tag, message, t);
        }
    }

    protected boolean shouldLog(int priority) {
        if (this.priorityFilterSet == null) {
            return this.baseTree.shouldLog(priority);
        }
        if (!this.priorityFilterSet.isEmpty()) {
            for (int priorityFilter : this.priorityFilterSet) {
                if (priority != priorityFilter) continue;
                return false;
            }
        }
        return true;
    }

    public void setPriorityFilterSet(@Nullable HashSet<Integer> priorityFilterSet) {
        this.priorityFilterSet = priorityFilterSet;
    }
}

