/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.trees;

import android.content.Context;
import android.support.annotation.NonNull;
import at.amartinz.universaldebug.trees.BaseTreeComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import timber.log.Timber;

public class BaseTree
extends Timber.DebugTree {
    private final Context applicationContext;
    private final HashSet<Integer> priorityFilterSet;
    private final List<BaseTreeComponent> baseTreeComponents;
    private boolean isEnabled;

    public BaseTree(@NonNull Context applicationContext, @NonNull Set<Integer> priorityFilterList) {
        this.applicationContext = applicationContext;
        this.priorityFilterSet = new HashSet<Integer>(priorityFilterList);
        this.baseTreeComponents = new ArrayList<BaseTreeComponent>();
        this.isEnabled = true;
    }

    public BaseTree setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @NonNull
    public Context getApplicationContext() {
        return this.applicationContext;
    }

    @NonNull
    public List<BaseTreeComponent> getComponents() {
        return this.baseTreeComponents;
    }

    public BaseTree addComponent(BaseTreeComponent baseTreeComponent) {
        this.baseTreeComponents.add(baseTreeComponent);
        return this;
    }

    public BaseTree removeComponent(BaseTreeComponent baseTreeComponent) {
        this.baseTreeComponents.remove(baseTreeComponent);
        return this;
    }

    public BaseTree removeComponent(Class clazz) {
        Iterator<BaseTreeComponent> iterator = this.baseTreeComponents.iterator();
        while (iterator.hasNext()) {
            BaseTreeComponent component = iterator.next();
            if (!clazz.isInstance(component)) continue;
            iterator.remove();
        }
        return this;
    }

    protected void log(int priority, String tag, String message, Throwable t) {
        if (!this.isEnabled) {
            return;
        }
        for (BaseTreeComponent baseTreeComponent : this.baseTreeComponents) {
            baseTreeComponent.log(priority, tag, message, t);
        }
    }

    public void reallyDoLog(int priority, String tag, String message, Throwable t) {
        super.log(priority, tag, message, t);
    }

    public boolean shouldLog(int priority) {
        if (!this.priorityFilterSet.isEmpty()) {
            for (int priorityFilter : this.priorityFilterSet) {
                if (priority != priorityFilter) continue;
                return false;
            }
        }
        return true;
    }

    public static String mapPriorityToString(int priority) {
        switch (priority) {
            default: {
                return "WTF";
            }
            case 3: {
                return "D";
            }
            case 6: {
                return "E";
            }
            case 4: {
                return "I";
            }
            case 2: {
                return "V";
            }
            case 5: 
        }
        return "W";
    }
}

