/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug.analytics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import at.amartinz.universaldebug.analytics.AnalyticsComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Analytics {
    private static Analytics sInstance;
    private final HashSet<AnalyticsComponent> analyticsComponents = new HashSet();

    private Analytics() {
    }

    public static Analytics get() {
        if (sInstance == null) {
            sInstance = new Analytics();
        }
        return sInstance;
    }

    public Analytics addComponent(AnalyticsComponent analyticsComponent) {
        this.analyticsComponents.add(analyticsComponent);
        return this;
    }

    public Analytics removeComponent(AnalyticsComponent analyticsComponent) {
        this.analyticsComponents.remove(analyticsComponent);
        return this;
    }

    public Analytics removeComponent(Class clazz) {
        Iterator<AnalyticsComponent> iterator = this.analyticsComponents.iterator();
        while (iterator.hasNext()) {
            AnalyticsComponent component = iterator.next();
            if (!clazz.isInstance(component)) continue;
            iterator.remove();
        }
        return this;
    }

    public Analytics logCustom(@NonNull String eventName, @Nullable Map<Object, Object> attributes) {
        for (AnalyticsComponent analyticsComponent : this.analyticsComponents) {
            analyticsComponent.logCustom(eventName, attributes);
        }
        return this;
    }

    public Analytics logAppOpened() {
        for (AnalyticsComponent analyticsComponent : this.analyticsComponents) {
            analyticsComponent.logAppOpened();
        }
        return this;
    }

    public Analytics logClickGeneric(@NonNull String name) {
        for (AnalyticsComponent analyticsComponent : this.analyticsComponents) {
            analyticsComponent.logClickGeneric(name);
        }
        return this;
    }

    public Analytics logClickButton(@NonNull String name) {
        for (AnalyticsComponent analyticsComponent : this.analyticsComponents) {
            analyticsComponent.logClickButton(name);
        }
        return this;
    }

    public static class Constants {
        public static final String EVENT_TEST = "test";
        public static final String EVENT_APP_OPENED = "app_opened";
        public static final String EVENT_CLICKED_GENERIC = "click_generic";
        public static final String EVENT_CLICKED_BUTTON = "click_button";
    }
}

