/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.universaldebug;

import android.content.Context;
import android.support.annotation.NonNull;
import at.amartinz.universaldebug.UniversalDebugExtension;
import at.amartinz.universaldebug.trees.BaseTree;
import at.amartinz.universaldebug.trees.LogComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import timber.log.Timber;

public class UniversalDebug {
    private final Context applicationContext;
    private final List<UniversalDebugExtension> extensionList;
    private boolean enableDebug;
    private boolean enableTimber;
    private Timber.Tree debugTree;
    private Timber.Tree productionTree;

    @NonNull
    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public UniversalDebug(Context applicationContext) {
        this.applicationContext = applicationContext;
        this.extensionList = new ArrayList<UniversalDebugExtension>();
    }

    public UniversalDebug withDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
        return this;
    }

    public UniversalDebug withTimber(boolean enableTimber) {
        this.enableTimber = enableTimber;
        return this;
    }

    public UniversalDebug withDebugTree(Timber.Tree debugTree) {
        this.debugTree = debugTree;
        return this;
    }

    public UniversalDebug withProductionTree(Timber.Tree productionTree) {
        this.productionTree = productionTree;
        return this;
    }

    public UniversalDebug withExtension(UniversalDebugExtension extension) {
        this.extensionList.add(extension);
        return this;
    }

    public UniversalDebug withExtensions(Collection<? extends UniversalDebugExtension> extensions) {
        this.extensionList.addAll(extensions);
        return this;
    }

    public void install() {
        if (this.enableTimber) {
            if (this.enableDebug) {
                if (this.debugTree == null) {
                    this.debugTree = UniversalDebug.buildDefaultDebugTree(this.applicationContext);
                }
                Timber.plant((Timber.Tree)this.debugTree);
            } else {
                if (this.productionTree == null) {
                    this.productionTree = UniversalDebug.buildDefaultProductionTree(this.applicationContext);
                }
                Timber.plant((Timber.Tree)this.productionTree);
            }
        }
        if (!this.extensionList.isEmpty()) {
            for (UniversalDebugExtension extension : this.extensionList) {
                if (!extension.canInstall(this.enableDebug)) continue;
                extension.install();
            }
        }
    }

    public static BaseTree buildDefaultDebugTree(@NonNull Context applicationContext) {
        BaseTree baseTree = new BaseTree(applicationContext, Collections.EMPTY_SET);
        baseTree.addComponent(new LogComponent(baseTree));
        return baseTree;
    }

    public static BaseTree buildDefaultProductionTree(@NonNull Context applicationContext) {
        HashSet<Integer> priorityFilter = new HashSet<Integer>(3);
        priorityFilter.add(3);
        priorityFilter.add(4);
        priorityFilter.add(2);
        BaseTree baseTree = new BaseTree(applicationContext, priorityFilter);
        baseTree.addComponent(new LogComponent(baseTree));
        return baseTree;
    }
}

