/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution.helper;

import android.text.TextUtils;
import at.amartinz.execution.NormalShell;
import java.util.List;

public class ProcessHelper {
    public static final int INVALID = -1;

    public static int getUidFromPid(int pid) {
        int result = ProcessHelper.getUidFromPidPerStat(pid);
        if (result == -1) {
            result = ProcessHelper.getUidFromPidPerStatusFile(pid);
        }
        return result;
    }

    public static int getUidFromPidPerStat(int pid) {
        String path = String.format("/proc/%s", pid);
        String cmd = String.format("stat -c %%u %s", path);
        String result = NormalShell.fireAndBlockString(cmd);
        if (!TextUtils.isEmpty((CharSequence)result)) {
            try {
                return Integer.parseInt(result.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getUidFromPidPerStatusFile(int pid) {
        String[] splitted;
        String path = String.format("/proc/%s/status", pid);
        String cmd = String.format("cat %s", path);
        List<String> result = NormalShell.fireAndBlockList(cmd);
        if (result == null || result.size() < 5) {
            return -1;
        }
        String uidLine = "";
        for (String line : result) {
            if (line == null || !line.toLowerCase().startsWith("uid")) continue;
            uidLine = line;
            break;
        }
        if ((splitted = (uidLine = uidLine.replace("\t", " ")).split(" ")).length < 2) {
            return -1;
        }
        try {
            return Integer.parseInt(splitted[1]);
        }
        catch (Exception exception) {
            try {
                return Integer.parseInt(splitted[2]);
            }
            catch (Exception exception2) {
                return -1;
            }
        }
    }
}

