/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import at.amartinz.execution.Installer;
import at.amartinz.execution.NormalShell;
import at.amartinz.execution.RootShell;
import at.amartinz.execution.ShellLogger;
import at.amartinz.execution.exceptions.RootDeniedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;

public class ShellManager {
    private static final String TAG = ShellManager.class.getSimpleName();
    private static ShellManager sInstance;
    private static final ArrayList<RootShell> rootShells;
    private static final ArrayList<NormalShell> normalShells;

    private ShellManager() {
        this.cleanupShells();
    }

    @NonNull
    public static ShellManager get() {
        if (sInstance == null) {
            sInstance = new ShellManager();
        }
        return sInstance;
    }

    public static void enableDebug(boolean enableDebug) {
        ShellLogger.DEBUG = enableDebug;
    }

    public static boolean isDebug() {
        return ShellLogger.DEBUG;
    }

    public ShellManager installBusyBox(@NonNull Context context) {
        Installer.installBusyBox(context);
        return this;
    }

    @Nullable
    public RootShell getRootShell() {
        return this.getRootShell(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RootShell getRootShell(boolean newShell) {
        RootShell rootShell;
        ArrayList<RootShell> arrayList = rootShells;
        synchronized (arrayList) {
            if (!newShell && rootShells.size() > 0 && (rootShell = rootShells.get(0)) != null) {
                return rootShell;
            }
        }
        rootShell = this.createRootShell();
        arrayList = rootShells;
        synchronized (arrayList) {
            rootShells.add(rootShell);
        }
        return rootShell;
    }

    @Nullable
    private RootShell createRootShell() {
        try {
            return new RootShell();
        }
        catch (RootDeniedException | IOException | TimeoutException e) {
            if (ShellLogger.DEBUG) {
                Log.e((String)TAG, (String)"Error creating new root shell", (Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public NormalShell getNormalShell() {
        return this.getNormalShell(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NormalShell getNormalShell(boolean newShell) {
        NormalShell normalShell;
        ArrayList<NormalShell> arrayList = normalShells;
        synchronized (arrayList) {
            if (!newShell && normalShells.size() > 0 && (normalShell = normalShells.get(0)) != null) {
                return normalShell;
            }
        }
        normalShell = this.createNormalShell();
        arrayList = normalShells;
        synchronized (arrayList) {
            normalShells.add(normalShell);
        }
        return normalShell;
    }

    @Nullable
    private NormalShell createNormalShell() {
        try {
            return new NormalShell();
        }
        catch (RootDeniedException | IOException | TimeoutException e) {
            if (ShellLogger.DEBUG) {
                Log.e((String)TAG, (String)"Error creating new shell", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRootShells() {
        ArrayList<RootShell> arrayList = rootShells;
        synchronized (arrayList) {
            if (rootShells.size() > 0) {
                Iterator<RootShell> rootShellIterator = rootShells.iterator();
                while (rootShellIterator.hasNext()) {
                    RootShell rootShell = rootShellIterator.next();
                    if (rootShell != null) {
                        rootShell.close();
                    }
                    rootShellIterator.remove();
                }
                rootShells.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupNormalShells() {
        ArrayList<NormalShell> arrayList = normalShells;
        synchronized (arrayList) {
            if (normalShells.size() > 0) {
                Iterator<NormalShell> normalShellIterator = normalShells.iterator();
                while (normalShellIterator.hasNext()) {
                    NormalShell normalShell = normalShellIterator.next();
                    if (normalShell != null) {
                        normalShell.close();
                    }
                    normalShellIterator.remove();
                }
                normalShells.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNormalShellCount() {
        ArrayList<NormalShell> arrayList = normalShells;
        synchronized (arrayList) {
            return normalShells.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRootShellCount() {
        ArrayList<RootShell> arrayList = rootShells;
        synchronized (arrayList) {
            return rootShells.size();
        }
    }

    public void cleanupShells() {
        this.cleanupRootShells();
        this.cleanupNormalShells();
    }

    public void onDestroy() {
        this.cleanupShells();
    }

    static {
        rootShells = new ArrayList();
        normalShells = new ArrayList();
    }
}

