/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import at.amartinz.execution.NormalShell;
import at.amartinz.execution.RootCheck;
import at.amartinz.execution.RootShell;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ShellHelper {
    @Nullable
    public static String findBinary(@NonNull String binaryName) {
        return ShellHelper.findBinary(binaryName, null);
    }

    @Nullable
    public static String findBinary(@NonNull String binaryName, @Nullable List<String> searchPaths) {
        List<String> foundLocations = ShellHelper.findBinaryLocations(binaryName, searchPaths);
        if (foundLocations.isEmpty()) {
            return null;
        }
        String firstLocation = foundLocations.get(0);
        if (TextUtils.isEmpty((CharSequence)firstLocation)) {
            return null;
        }
        return firstLocation;
    }

    @NonNull
    public static List<String> findBinaryLocations(@NonNull String binaryName) {
        return ShellHelper.findBinaryLocations(binaryName, null);
    }

    @NonNull
    public static List<String> findBinaryLocations(@NonNull String binaryName, @Nullable List<String> searchPaths) {
        String busybox;
        ArrayList<String> foundLocations = new ArrayList<String>();
        if (searchPaths == null) {
            searchPaths = ShellHelper.getPath();
        }
        searchPaths = ShellHelper.ensureListFormat(searchPaths);
        for (String searchPath : searchPaths) {
            File expectedBinary = new File(searchPath, binaryName);
            if (!expectedBinary.exists()) continue;
            foundLocations.add(searchPath);
        }
        if (!foundLocations.isEmpty()) {
            return foundLocations;
        }
        String string = busybox = RootCheck.isRooted() ? RootShell.fireAndBlockString("which busybox") : NormalShell.fireAndBlockString("which busybox");
        if (!TextUtils.isEmpty((CharSequence)busybox) && busybox.endsWith("/busybox")) {
            foundLocations.add(0, busybox.trim());
        }
        return foundLocations;
    }

    @NonNull
    public static List<String> getPath() {
        String path = System.getenv("PATH");
        if (TextUtils.isEmpty((CharSequence)path)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(path.split(":"));
    }

    @NonNull
    private static List<String> ensureListFormat(@NonNull List<String> listToFormat) {
        ArrayList<String> formattedList = new ArrayList<String>();
        for (String searchPath : listToFormat) {
            String path = searchPath.endsWith("/") ? searchPath : String.format("%s/", searchPath);
            formattedList.add(path);
        }
        return formattedList;
    }
}

