/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import at.amartinz.execution.NormalShell;
import at.amartinz.execution.RootShell;
import at.amartinz.execution.ShellLogger;
import at.amartinz.execution.ShellManager;
import java.io.File;

public class RootCheck {
    private static final String TAG = RootCheck.class.getSimpleName();
    private static final String[] PATH_SU = new String[]{"/system/bin/su", "/system/xbin/su", "/system/bin/.ext/.su", "/system/xbin/sugote", "/su/bin/su"};
    private static Boolean isRooted = null;
    private static Boolean isRootGranted = null;
    private static String suVersion = null;

    public static boolean isRooted() {
        return RootCheck.isRooted(false);
    }

    public static boolean isRooted(boolean forceCheck) {
        if (!forceCheck && isRooted != null) {
            return isRooted;
        }
        String suPath = RootCheck.getSuPath();
        if (!TextUtils.isEmpty((CharSequence)suPath)) {
            if (ShellLogger.DEBUG) {
                Log.d((String)TAG, (String)String.format("Found su path: %s", suPath));
            }
            isRooted = true;
            return true;
        }
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)"no su binary found, trying with hit and miss");
        }
        RootShell.fireAndForget("id");
        RootShell rootShell = ShellManager.get().getRootShell();
        isRooted = rootShell != null;
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)String.format("is rooted: %s", isRooted));
        }
        return isRooted;
    }

    @WorkerThread
    public static boolean isRootGranted() {
        return RootCheck.isRootGranted(false);
    }

    @WorkerThread
    public static boolean isRootGranted(boolean forceCheck) {
        if (!forceCheck && isRootGranted != null) {
            return isRootGranted;
        }
        if (!RootCheck.isRooted()) {
            isRootGranted = false;
            return false;
        }
        String result = RootShell.fireAndBlockString("id");
        if (TextUtils.isEmpty((CharSequence)result)) {
            isRootGranted = false;
            return false;
        }
        isRootGranted = result.contains("uid=0");
        return isRootGranted;
    }

    @WorkerThread
    @NonNull
    public static String getSuVersion() {
        return RootCheck.getSuVersion(false);
    }

    @WorkerThread
    @NonNull
    public static String getSuVersion(boolean forceCheck) {
        if (forceCheck || suVersion == null) {
            String version;
            String string = version = RootCheck.isRooted() ? NormalShell.fireAndBlockString("su -v") : "-";
            if (TextUtils.isEmpty((CharSequence)version)) {
                version = RootShell.fireAndBlockString("su -v");
            }
            suVersion = TextUtils.isEmpty((CharSequence)version) ? "-" : version;
        }
        return suVersion;
    }

    @Nullable
    public static String getSuPath() {
        for (String path : PATH_SU) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }
}

