/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import at.amartinz.execution.IoUtils;
import at.amartinz.execution.ShellLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Installer {
    private static final String TAG = Installer.class.getSimpleName();
    private static final String KEY_BUSYBOX_VERSION = "busybox_version";
    private static final int BUSYBOX_VERSION = 1;

    public static boolean installBusyBox(@NonNull Context context) {
        return Installer.installBusyBox(context, false);
    }

    public static boolean installBusyBox(@NonNull Context context, boolean force) {
        if (!force && Installer.binaryExists(context, "busybox")) {
            if (ShellLogger.DEBUG) {
                Log.v((String)TAG, (String)"busybox already installed!");
            }
            return false;
        }
        return Installer.extractBinary(context, "busybox", KEY_BUSYBOX_VERSION, 1);
    }

    public static boolean extractBinary(@NonNull Context context, @NonNull String binaryName) {
        return Installer.extractBinary(context, binaryName, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractBinary(@NonNull Context context, @NonNull String binaryName, @Nullable String versionKey, int versionNew) {
        block17: {
            boolean extractedBinary;
            SharedPreferences prefs;
            block16: {
                File binary;
                boolean shouldExtract;
                boolean checkVersion = !TextUtils.isEmpty((CharSequence)versionKey) && versionNew != -1;
                File filesDir = context.getFilesDir();
                if (!filesDir.exists()) {
                    filesDir.mkdirs();
                }
                boolean bl = shouldExtract = !(binary = new File(filesDir, binaryName)).exists();
                if (checkVersion) {
                    prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
                    shouldExtract = shouldExtract || prefs.getInt(versionKey, 0) < versionNew;
                } else {
                    prefs = null;
                }
                if (!shouldExtract) break block17;
                extractedBinary = false;
                AssetManager am = context.getAssets();
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    is = am.open(binaryName);
                    binary.createNewFile();
                    os = new FileOutputStream(binary);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    try {
                        int read;
                        byte[] buffer = new byte[1024];
                        while ((read = bis.read(buffer)) != -1) {
                            bos.write(buffer, 0, read);
                        }
                    }
                    finally {
                        IoUtils.closeQuietly(bos);
                        IoUtils.closeQuietly(bis);
                    }
                    binary.setExecutable(true);
                    extractedBinary = true;
                    IoUtils.closeQuietly(os);
                }
                catch (IOException ioe) {
                    if (ShellLogger.DEBUG) {
                        Log.e((String)TAG, (String)String.format("Could not extract %s binary", binary), (Throwable)ioe);
                    }
                    break block16;
                }
                finally {
                    IoUtils.closeQuietly(os);
                    IoUtils.closeQuietly(is);
                }
                IoUtils.closeQuietly(is);
            }
            if (prefs != null && extractedBinary) {
                if (ShellLogger.DEBUG) {
                    Log.v((String)TAG, (String)String.format("Successfully extracted %s version \"%s\"", binaryName, versionNew));
                }
                prefs.edit().putInt(versionKey, versionNew).apply();
            }
            return extractedBinary;
        }
        return false;
    }

    public static boolean binaryExists(@NonNull Context context, @NonNull String name) {
        File filesDir = context.getFilesDir();
        if (!filesDir.exists()) {
            return false;
        }
        File binary = new File(filesDir, name);
        return binary.exists() && binary.canExecute();
    }
}

