/*
 * Decompiled with CFR 0.152.
 */
package at.allaboutapps.web.webview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.MailTo;
import android.net.Uri;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import at.allaboutapps.web.webview.R;
import at.allaboutapps.web.webview.WebViewSettings;

public class A3WebView
extends FrameLayout {
    private ProgressBar mProgress;
    private WebView mWebView;
    private View mError;
    private WebViewSettings mSettings;

    public A3WebView(@NonNull Context context) {
        super(context);
        this.initialize(context);
    }

    public A3WebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public A3WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @TargetApi(value=21)
    public A3WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mProgress = new ProgressBar(context);
        this.mProgress.setIndeterminate(true);
        FrameLayout.LayoutParams progressLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        progressLayoutParams.gravity = 17;
        this.mProgress.setLayoutParams((ViewGroup.LayoutParams)progressLayoutParams);
        this.addView((View)this.mProgress);
        this.mWebView = new WebView(context);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.mWebView);
    }

    public void loadWithSettings(WebViewSettings settings) {
        this.mSettings = settings;
        if (this.mError != null) {
            this.removeView(this.mError);
            this.mError = null;
        }
        this.mWebView.getSettings();
        if (settings.showLoading) {
            this.showProgress();
        } else {
            this.showWebView();
        }
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(settings.javaScriptEnabled);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(false);
        webSettings.setDisplayZoomControls(false);
        this.mWebView.setWebViewClient((android.webkit.WebViewClient)new WebViewClient(settings));
        this.startLoadingContent(settings);
        settings.loadingMethod.startLoading(this.mWebView);
    }

    private void showProgress() {
        this.mWebView.setVisibility(8);
        this.mProgress.setVisibility(0);
        if (this.mError != null) {
            this.mError.setVisibility(8);
        }
    }

    private void startLoadingContent(WebViewSettings settings) {
        this.mWebView.requestFocusFromTouch();
        settings.loadingMethod.startLoading(this.mWebView);
    }

    public boolean canGoBack() {
        return this.mWebView.canGoBack();
    }

    public void goBack() {
        this.mWebView.goBack();
    }

    private void showWebView() {
        this.mWebView.setVisibility(0);
        this.mWebView.requestFocusFromTouch();
        this.mProgress.setVisibility(8);
        if (this.mError != null) {
            this.mError.setVisibility(8);
        }
    }

    private void showError(final String failedUrl) {
        this.mWebView.setVisibility(8);
        this.mProgress.setVisibility(8);
        if (this.mError != null) {
            this.mError.setVisibility(0);
        } else {
            this.mError = LayoutInflater.from((Context)this.getContext()).inflate(this.mSettings.errorLayout, (ViewGroup)this, false);
            this.mError.findViewById(R.id.action_reload).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    A3WebView.this.mWebView.loadUrl(failedUrl);
                    if (((A3WebView)A3WebView.this).mSettings.showLoading) {
                        A3WebView.this.showProgress();
                    } else {
                        A3WebView.this.showWebView();
                    }
                }
            });
            this.addView(this.mError);
        }
    }

    private class WebViewClient
    extends android.webkit.WebViewClient {
        private static final String PREFIX_HTTP = "http:";
        private static final String PREFIX_HTTPS = "https:";
        private static final String PREFIX_TEL = "tel:";
        private static final String PREFIX_MAIL_TO = "mailto:";
        private final WebViewSettings mSettings;
        private String mFailedUrl;

        public WebViewClient(WebViewSettings settings) {
            this.mSettings = settings;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (this.isHttpUrl(url)) {
                if (this.mSettings.openLinksExternally) {
                    Intent urlIntent = this.newUrlIntent(url);
                    view.getContext().startActivity(Intent.createChooser((Intent)urlIntent, (CharSequence)""));
                    return true;
                }
                return false;
            }
            if (this.isPhoneNumberUrl(url)) {
                Intent telIntent = new Intent("android.intent.action.DIAL", Uri.parse((String)url));
                view.getContext().startActivity(Intent.createChooser((Intent)telIntent, (CharSequence)""));
                return true;
            }
            if (this.isMailToUrl(url)) {
                MailTo mt = MailTo.parse((String)url);
                Intent mailToIntent = this.newEmailIntent(mt.getTo(), mt.getSubject(), mt.getBody(), mt.getCc());
                view.getContext().startActivity(Intent.createChooser((Intent)mailToIntent, (CharSequence)""));
                return true;
            }
            return false;
        }

        public Intent newEmailIntent(String address, String subject, String body, String cc) {
            Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)address, null));
            intent.putExtra("android.intent.extra.EMAIL", address);
            intent.putExtra("android.intent.extra.TEXT", body);
            intent.putExtra("android.intent.extra.SUBJECT", subject);
            intent.putExtra("android.intent.extra.CC", cc);
            return intent;
        }

        private Intent newUrlIntent(String url) {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setData(Uri.parse((String)url));
            return i;
        }

        private boolean isMailToUrl(String url) {
            return url.startsWith(PREFIX_MAIL_TO);
        }

        private boolean isPhoneNumberUrl(String url) {
            return url.startsWith(PREFIX_TEL);
        }

        private boolean isHttpUrl(String url) {
            return url.startsWith(PREFIX_HTTP) || url.startsWith(PREFIX_HTTPS);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            this.mFailedUrl = failingUrl;
            A3WebView.this.showError(this.mFailedUrl);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.mFailedUrl != null && this.mFailedUrl.equals(url)) {
                this.mFailedUrl = null;
                return;
            }
            A3WebView.this.showWebView();
        }
    }
}

