/*
 * Decompiled with CFR 0.152.
 */
package app.youkai.simpleratingview;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import app.youkai.simpleratingview.R;

public class SimpleRatingView
extends LinearLayout {
    private ImageView awful;
    private ImageView meh;
    private ImageView good;
    private ImageView amazing;
    private OnRatingSelectedListener listener;
    private Rating rating = Rating.NO_RATING;

    public SimpleRatingView(Context context) {
        this(context, null);
    }

    public SimpleRatingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimpleRatingView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public SimpleRatingView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs);
        this.init(attrs, defStyle, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.view_simpleratingview, (ViewGroup)this, true);
        this.setOrientation(0);
        this.setGravity(16);
        this.awful = (ImageView)this.findViewById(R.id.awful);
        this.meh = (ImageView)this.findViewById(R.id.meh);
        this.good = (ImageView)this.findViewById(R.id.good);
        this.amazing = (ImageView)this.findViewById(R.id.amazing);
        View.OnTouchListener animTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        v.animate().scaleXBy(0.1f).setDuration(50L).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).start();
                        v.animate().scaleYBy(0.1f).setDuration(50L).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).start();
                        break;
                    }
                    case 1: {
                        v.animate().scaleX(1.0f).setDuration(50L).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).start();
                        v.animate().scaleY(1.0f).setDuration(50L).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).start();
                    }
                }
                return false;
            }
        };
        this.awful.setOnTouchListener(animTouchListener);
        this.meh.setOnTouchListener(animTouchListener);
        this.good.setOnTouchListener(animTouchListener);
        this.amazing.setOnTouchListener(animTouchListener);
        this.awful.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleRatingView.this.setRating(Rating.AWFUL);
            }
        });
        this.meh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleRatingView.this.setRating(Rating.MEH);
            }
        });
        this.good.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleRatingView.this.setRating(Rating.GOOD);
            }
        });
        this.amazing.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleRatingView.this.setRating(Rating.AMAZING);
            }
        });
        this.awful.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                SimpleRatingView.this.showTooltip(Rating.AWFUL, v);
                return true;
            }
        });
        this.meh.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                SimpleRatingView.this.showTooltip(Rating.MEH, v);
                return true;
            }
        });
        this.good.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                SimpleRatingView.this.showTooltip(Rating.GOOD, v);
                return true;
            }
        });
        this.amazing.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                SimpleRatingView.this.showTooltip(Rating.AMAZING, v);
                return true;
            }
        });
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.rating = this.rating;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.rating = savedState.rating;
    }

    public void setListener(OnRatingSelectedListener listener) {
        this.listener = listener;
    }

    public void setRating(Rating rating) {
        if (rating == this.rating) {
            rating = Rating.NO_RATING;
        }
        this.rating = rating;
        int transparent = this.getResources().getColor(17170445);
        switch (rating) {
            case AWFUL: {
                this.awful.setBackgroundResource(R.drawable.srv_selected_awful);
                this.meh.setBackgroundColor(transparent);
                this.good.setBackgroundColor(transparent);
                this.amazing.setBackgroundColor(transparent);
                break;
            }
            case MEH: {
                this.awful.setBackgroundColor(transparent);
                this.meh.setBackgroundResource(R.drawable.srv_selected_meh);
                this.good.setBackgroundColor(transparent);
                this.amazing.setBackgroundColor(transparent);
                break;
            }
            case GOOD: {
                this.awful.setBackgroundColor(transparent);
                this.meh.setBackgroundColor(transparent);
                this.good.setBackgroundResource(R.drawable.srv_selected_good);
                this.amazing.setBackgroundColor(transparent);
                break;
            }
            case AMAZING: {
                this.awful.setBackgroundColor(transparent);
                this.meh.setBackgroundColor(transparent);
                this.good.setBackgroundColor(transparent);
                this.amazing.setBackgroundResource(R.drawable.srv_selected_amazing);
                break;
            }
            case NO_RATING: {
                this.awful.setBackgroundColor(transparent);
                this.meh.setBackgroundColor(transparent);
                this.good.setBackgroundColor(transparent);
                this.amazing.setBackgroundColor(transparent);
            }
        }
        if (this.listener != null) {
            this.listener.onRatingSelected(rating);
        }
    }

    public Rating getRating() {
        return this.rating;
    }

    private void showTooltip(Rating rating, View anchor) {
        Toast toast = Toast.makeText((Context)this.getContext(), (int)rating.getStringRes(), (int)0);
        toast.setGravity(0, Math.round(anchor.getX() - (float)(anchor.getMeasuredWidth() * 2)), (int)Math.round((double)anchor.getY() - (double)anchor.getMeasuredHeight() * 1.5));
        toast.show();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private Rating rating;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.rating = Rating.fromString(in.readString());
        }

        public void writeToParcel(Parcel out, int flags) {
            if (out == null) {
                return;
            }
            super.writeToParcel(out, flags);
            out.writeString(this.rating.toString());
        }
    }

    public static enum Rating {
        AWFUL("awful"),
        MEH("meh"),
        GOOD("good"),
        AMAZING("amazing"),
        NO_RATING("none");

        private String value;

        private Rating(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Rating fromString(String value) {
            switch (value) {
                case "awful": {
                    return AWFUL;
                }
                case "meh": {
                    return MEH;
                }
                case "good": {
                    return GOOD;
                }
                case "amazing": {
                    return AMAZING;
                }
            }
            return NO_RATING;
        }

        public int getStringRes() {
            switch (this.value) {
                case "awful": {
                    return R.string.srv_awful;
                }
                case "meh": {
                    return R.string.srv_meh;
                }
                case "good": {
                    return R.string.srv_good;
                }
                case "amazing": {
                    return R.string.srv_amazing;
                }
            }
            return R.string.srv_no_rating;
        }
    }

    public static interface OnRatingSelectedListener {
        public void onRatingSelected(Rating var1);
    }
}

