package app.raybritton.elog.ui

import android.app.Activity
import android.app.AlertDialog
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.TextView
import android.widget.Toast
import androidx.core.content.FileProvider
import app.raybritton.elog.BuildConfig
import app.raybritton.elog.ELog
import app.raybritton.elog.ELog.context
import app.raybritton.elog.ELogConfig
import app.raybritton.elog.R
import app.raybritton.elog.arch.LogModule
import app.raybritton.elog.data.LogFile
import app.raybritton.elog.data.Result
import kotlinx.android.synthetic.main.elog_activity_submit.*
import java.text.SimpleDateFormat
import java.util.*
import kotlin.concurrent.thread


internal class AlreadySentActivity : Activity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.elog_activity_submit)
        setStatusBarColor(ELogConfig.toolbarBackgroundColor)

        val code = intent.getStringExtra(ARG_CODE)!!

        elog_submit_progress.visibility = View.GONE
        elog_submit_text.text = getString(R.string.elog_send_success, ELog.contactName)
        if (code.all { it.isDigit() }) {
            setCopyOnClick(elog_submit_code_number, code)
        } else {
            setCopyOnClick(elog_submit_code_mixed, code)
        }
        setResult(RESULT_OK)
        elog_submit_text.visibility = View.VISIBLE
        elog_submit_close.visibility = View.VISIBLE
        elog_submit_close.setOnClickListener {
            finish()
        }
    }

    private fun setCopyOnClick(tv: TextView, code: String) {
        tv.text = code
        tv.visibility = View.VISIBLE
        tv.setOnClickListener {
            val clipboard = getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
            val clip = ClipData.newPlainText("code", tv.text)
            clipboard.setPrimaryClip(clip)
            Toast.makeText(this, getString(R.string.elog_copied), Toast.LENGTH_SHORT).show()
        }
    }

    companion object {
        private const val ARG_CODE = "code.string"

        internal fun start(ctx: Activity, code: String) {
            val intent = Intent(ctx, AlreadySentActivity::class.java)
            intent.putExtra(ARG_CODE, code)
            ctx.startActivity(intent)
        }
    }
}