/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers.jni;

import ai.djl.engine.EngineException;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = System.mapLibraryName("tokenizers");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)-(\\d+\\.\\d+\\.\\d+)(-SNAPSHOT)?(-\\d+)?");
    private static final int[] SUPPORTED_CUDA_VERSIONS = new int[]{122};
    private static final Set<String> SUPPORTED_CUDA_ARCH = new HashSet<String>(Arrays.asList("80", "86", "89", "90"));
    private static EngineException exception;

    private LibUtils() {
    }

    public static void checkStatus() {
        if (exception != null) {
            throw exception;
        }
    }

    private static void loadLibrary() {
        if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
            System.loadLibrary("djl_tokenizer");
            return;
        }
        String[] libs = System.getProperty("os.name").startsWith("Windows") ? new String[]{"libwinpthread-1.dll", "libgcc_s_seh-1.dll", "libstdc++-6.dll", LIB_NAME} : new String[]{LIB_NAME};
        Platform platform = Platform.detectPlatform((String)"tokenizers");
        Path dir = LibUtils.findOverrideLibrary(platform);
        if (dir == null) {
            dir = LibUtils.copyJniLibrary(libs, platform);
        }
        logger.debug("Loading huggingface library from: {}", (Object)dir);
        for (String libName : libs) {
            String path = dir.resolve(libName).toString();
            logger.debug("Loading native library: {}", (Object)path);
            String nativeHelper = System.getProperty("ai.djl.huggingface.native_helper");
            if (nativeHelper != null && !nativeHelper.isEmpty()) {
                ClassLoaderUtils.nativeLoad((String)nativeHelper, (String)path);
                continue;
            }
            System.load(path);
        }
    }

    private static Path findOverrideLibrary(Platform platform) {
        String libPath = Utils.getEnvOrSystemProperty((String)"RUST_LIBRARY_PATH");
        if (libPath != null) {
            logger.info("Override Rust library path: {}", (Object)libPath);
            Path path = Paths.get(libPath, new String[0]);
            String fileName = Objects.requireNonNull(path.getFileName()).toString();
            if (Files.isRegularFile(path, new LinkOption[0]) && LIB_NAME.equals(fileName)) {
                return path.getParent();
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                Path file;
                String cudaArch = platform.getCudaArch();
                if (!cudaArch.isEmpty()) {
                    path = path.resolve(cudaArch);
                }
                if (Files.exists(file = path.resolve(LIB_NAME), new LinkOption[0])) {
                    return path;
                }
            }
            throw new EngineException("No native rust library found in: " + libPath);
        }
        return null;
    }

    private static Path copyJniLibrary(String[] libs, Platform platform) {
        String flavor;
        boolean override;
        Path cacheDir = Utils.getEngineCacheDir((String)"tokenizers");
        String os = platform.getOsPrefix();
        String classifier = platform.getClassifier();
        String version = platform.getVersion();
        String cudaArch = platform.getCudaArch();
        if (cudaArch == null) {
            cudaArch = "";
        }
        boolean bl = override = (flavor = Utils.getEnvOrSystemProperty((String)"RUST_FLAVOR")) != null && !flavor.isEmpty();
        if (override) {
            logger.info("Uses override RUST_FLAVOR: {}", (Object)flavor);
        } else {
            flavor = Utils.isOfflineMode() || "win".equals(os) ? "cpu" : platform.getFlavor();
        }
        if (flavor.startsWith("cu")) {
            boolean match = false;
            if (SUPPORTED_CUDA_ARCH.contains(cudaArch)) {
                int cudaVersion = Integer.parseInt(flavor.substring(2, 5));
                for (int v : SUPPORTED_CUDA_VERSIONS) {
                    if (override && cudaVersion == v) {
                        match = true;
                        break;
                    }
                    if (cudaVersion < v) continue;
                    flavor = "cu" + v;
                    match = true;
                    break;
                }
            }
            if (!match) {
                logger.warn("No matching cuda flavor for {} found: {}/sm_{}.", new Object[]{classifier, flavor, cudaArch});
                flavor = "cpu";
                cudaArch = "";
            }
        }
        Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
        if (!cudaArch.isEmpty()) {
            dir = dir.resolve(cudaArch);
        }
        logger.debug("Using cache dir: {}", (Object)dir);
        Path path = dir.resolve(LIB_NAME);
        if (Files.exists(path, new LinkOption[0])) {
            return dir.toAbsolutePath();
        }
        if (LibUtils.copyJniLibraryFromClasspath(libs, dir, classifier, flavor)) {
            return dir.toAbsolutePath();
        }
        if (flavor.startsWith("cu")) {
            Matcher matcher = VERSION_PATTERN.matcher(version);
            if (!matcher.matches()) {
                throw new EngineException("Unexpected version: " + version);
            }
            String jniVersion = matcher.group(1);
            String djlVersion = matcher.group(3);
            LibUtils.downloadJniLib(path, djlVersion, jniVersion, classifier, flavor + '-' + cudaArch);
            return dir.toAbsolutePath();
        }
        throw new EngineException("Unexpected flavor: " + flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyJniLibraryFromClasspath(String[] libs, Path dir, String classifier, String flavor) {
        boolean bl;
        Path tmp;
        block16: {
            boolean bl2;
            block15: {
                tmp = null;
                try {
                    Path parent = Objects.requireNonNull(dir.getParent());
                    Files.createDirectories(parent, new FileAttribute[0]);
                    tmp = Files.createTempDirectory(parent, "tmp", new FileAttribute[0]);
                    for (String libName : libs) {
                        String libPath = "native/lib/" + classifier + "/" + flavor + "/" + libName;
                        if (ClassLoaderUtils.getResource((String)libPath) == null) {
                            logger.info("library not found in classpath: {}", (Object)libPath);
                            bl2 = false;
                            if (tmp == null) return bl2;
                            break block15;
                        }
                        logger.info("Extracting {} to cache ...", (Object)libPath);
                        try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)libPath);){
                            Path target = tmp.resolve(libName);
                            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    Utils.moveQuietly((Path)tmp, (Path)dir);
                    bl = true;
                    if (tmp == null) return bl;
                    break block16;
                }
                catch (IOException e) {
                    logger.error("Cannot copy jni files", (Throwable)e);
                    return false;
                }
            }
            Utils.deleteQuietly((Path)tmp);
            return bl2;
        }
        Utils.deleteQuietly((Path)tmp);
        return bl;
        finally {
            if (tmp != null) {
                Utils.deleteQuietly(tmp);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void downloadJniLib(Path path, String djlVersion, String version, String classifier, String flavor) {
        String url = "https://publish.djl.ai/tokenizers/" + version + "/jnilib/" + djlVersion + '/' + classifier + '/' + flavor + '/' + LIB_NAME;
        logger.info("Downloading jni {} to cache ...", (Object)url);
        Path parent = Objects.requireNonNull(path.getParent());
        Path tmp = null;
        try {
            try (InputStream is = Utils.openUrl((String)url);){
                Files.createDirectories(parent, new FileAttribute[0]);
                tmp = Files.createTempFile(parent, "jni", "tmp", new FileAttribute[0]);
                Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
            }
            if (tmp == null) return;
        }
        catch (IOException e) {
            try {
                throw new EngineException("Cannot download jni files: " + url, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (tmp == null) throw throwable;
                Utils.deleteQuietly(tmp);
                throw throwable;
            }
        }
        Utils.deleteQuietly((Path)tmp);
        return;
    }

    static {
        try {
            LibUtils.loadLibrary();
        }
        catch (RuntimeException e) {
            exception = new EngineException("Failed to load Huggingface native library.", (Throwable)e);
        }
    }
}

