/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.engine.rpc.RpcTranslatorFactory;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RpcRepository
extends AbstractRepository {
    private String artifactId;
    private String modelName;

    RpcRepository(String name, URI uri) {
        super(name, uri);
        this.modelName = (String)this.arguments.get("model_name");
        this.artifactId = (String)this.arguments.get("artifact_id");
        if (this.artifactId == null) {
            this.artifactId = "rpc";
        }
        if (this.modelName == null) {
            this.modelName = this.artifactId;
        }
        this.arguments.put("translatorFactory", RpcTranslatorFactory.class.getName());
        this.arguments.put("engine", "RPC");
        this.arguments.put("djl_rpc_uri", uri.toString());
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        return this.getMetadata();
    }

    @Override
    public Artifact resolve(MRL mrl, Map<String, String> filter) throws IOException {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public List<MRL> getResources() {
        MRL mrl = MRL.undefined(this, "ai.djl.localmodelzoo", this.artifactId);
        return Collections.singletonList(mrl);
    }

    @Override
    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) {
    }

    private synchronized Metadata getMetadata() {
        Artifact artifact = new Artifact();
        artifact.setName(this.modelName);
        artifact.getArguments().putAll(this.arguments);
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        Artifact.Item item = new Artifact.Item();
        item.setUri(this.uri.getPath());
        item.setName("");
        item.setArtifact(artifact);
        item.setSize(0L);
        files.put(this.artifactId, item);
        artifact.setFiles(files);
        Metadata.MatchAllMetadata metadata = new Metadata.MatchAllMetadata();
        metadata.setArtifactId(this.artifactId);
        metadata.setArtifacts(Collections.singletonList(artifact));
        String hash = Utils.hash(this.uri.toString());
        MRL mrl = this.model(Application.UNDEFINED, "ai.djl.localmodelzoo", hash);
        metadata.setRepositoryUri(mrl.toURI());
        return metadata;
    }
}

