/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.Device;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDScope;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Function;

public abstract class NDArrayAdapter
implements NDArray {
    private static final String UNSUPPORTED_MSG = "This NDArray implementation does not currently support this operation";
    protected NDManager manager;
    protected NDManager alternativeManager;
    protected NDArray alternativeArray;
    protected Shape shape;
    protected DataType dataType;
    protected String name;
    protected boolean isClosed;
    protected String uid;

    protected NDArrayAdapter(NDManager manager, NDManager alternativeManager, Shape shape, DataType dataType, String uid) {
        this.manager = manager;
        this.alternativeManager = alternativeManager;
        this.shape = shape;
        this.dataType = dataType;
        this.uid = uid;
    }

    @Override
    public NDManager getManager() {
        return this.manager;
    }

    @Override
    public void attach(NDManager manager) {
        this.detach();
        this.manager = manager;
        manager.attachInternal(this.getUid(), this);
        this.alternativeManager = ((BaseNDManager)manager).getAlternativeManager();
        if (this.alternativeManager == null) {
            this.alternativeManager = manager;
        }
    }

    @Override
    public void tempAttach(NDManager manager) {
        NDManager original = this.manager;
        this.detach();
        this.manager = manager;
        manager.tempAttachInternal(original, this.getUid(), this);
    }

    @Override
    public SparseFormat getSparseFormat() {
        return SparseFormat.DENSE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Device getDevice() {
        return this.manager.getDevice();
    }

    @Override
    public DataType getDataType() {
        if (this.isClosed) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        return this.dataType;
    }

    @Override
    public Shape getShape() {
        if (this.isClosed) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        return this.shape;
    }

    @Override
    public NDArray toDevice(Device device, boolean copy) {
        if (device.equals(this.getDevice())) {
            if (copy) {
                return this.duplicate();
            }
            return this;
        }
        NDArray array = this.getManager().create(this.getShape(), this.getDataType(), device);
        array.setName(this.getName());
        this.copyTo(array);
        return array;
    }

    @Override
    public NDArray toType(DataType dataType, boolean copy) {
        if (dataType.equals((Object)this.getDataType())) {
            if (copy) {
                return this.duplicate();
            }
            return this;
        }
        Number[] numbers = this.toArray();
        ByteBuffer bb = this.toTypeInternal(numbers, dataType);
        NDArray array = this.manager.create(bb, this.getShape(), dataType);
        array.setName(this.getName());
        return array;
    }

    private ByteBuffer toTypeInternal(Number[] numbers, DataType dataType) {
        int size = dataType.getNumOfBytes() * numbers.length;
        ByteBuffer bb = this.manager.allocateDirect(size);
        block8: for (Number number : numbers) {
            switch (dataType) {
                case FLOAT16: 
                case FLOAT32: {
                    bb.putFloat(number.floatValue());
                    continue block8;
                }
                case FLOAT64: {
                    bb.putDouble(number.doubleValue());
                    continue block8;
                }
                case INT16: 
                case UINT16: {
                    bb.putShort(number.shortValue());
                    continue block8;
                }
                case INT32: 
                case UINT32: {
                    bb.putInt(number.intValue());
                    continue block8;
                }
                case INT64: 
                case UINT64: {
                    bb.putLong(number.longValue());
                    continue block8;
                }
                case BOOLEAN: 
                case INT8: 
                case UINT8: {
                    bb.put(number.byteValue());
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unsupported DataType: " + (Object)((Object)this.getDataType()));
                }
            }
        }
        bb.rewind();
        return bb;
    }

    @Override
    public void setRequiresGradient(boolean requiresGrad) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray getGradient() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public boolean hasGradient() {
        return false;
    }

    @Override
    public NDArray stopGradient() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public String[] toStringArray(Charset charset) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray gather(NDArray index, int axis) {
        return this.getAlternativeArray().gather(this.alternativeManager.from(index), axis);
    }

    @Override
    public NDArray gatherNd(NDArray index) {
        return this.getAlternativeArray().gatherNd(this.alternativeManager.from(index));
    }

    @Override
    public NDArray take(NDManager manager, NDArray index) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray put(NDArray index, NDArray value) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray scatter(NDArray index, NDArray value, int axis) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray get(NDIndex index) {
        return this.get(this.alternativeManager, index);
    }

    @Override
    public void set(Buffer buffer) {
        NDArray array = this.manager.create(buffer, this.getShape(), this.getDataType());
        this.intern(array);
        array.detach();
    }

    @Override
    public void set(NDIndex index, NDArray value) {
        this.getAlternativeArray().set(index, value);
        this.set(this.alternativeArray.toByteBuffer());
    }

    @Override
    public void set(NDIndex index, Number value) {
        this.getAlternativeArray().set(index, value);
        this.set(this.alternativeArray.toByteBuffer());
    }

    @Override
    public void set(NDIndex index, Function<NDArray, NDArray> function) {
        this.getAlternativeArray().set(index, function);
        this.set(this.alternativeArray.toByteBuffer());
    }

    @Override
    public void set(NDArray index, Number value) {
        this.getAlternativeArray().set(index, value);
        this.set(this.alternativeArray.toByteBuffer());
    }

    @Override
    public void setScalar(NDIndex index, Number value) {
        this.getAlternativeArray().setScalar(index, value);
        this.set(this.alternativeArray.toByteBuffer());
    }

    @Override
    public NDArray booleanMask(NDArray index, int axis) {
        return this.getAlternativeArray().booleanMask(this.alternativeManager.from(index), axis);
    }

    @Override
    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        return this.getAlternativeArray().sequenceMask(this.alternativeManager.from(sequenceLength), value);
    }

    @Override
    public NDArray sequenceMask(NDArray sequenceLength) {
        return this.sequenceMask(sequenceLength, 0.0f);
    }

    @Override
    public boolean contentEquals(Number number) {
        return Arrays.stream(this.toArray()).allMatch(n -> n.equals(number));
    }

    @Override
    public boolean contentEquals(NDArray other) {
        if (other instanceof NDArrayAdapter) {
            return this.getShape().equals(other.getShape()) && Arrays.equals(this.toByteArray(), other.toByteArray());
        }
        return other.contentEquals(this);
    }

    @Override
    public NDArray eq(Number n) {
        return this.getAlternativeArray().eq(n);
    }

    @Override
    public NDArray eq(NDArray other) {
        return this.getAlternativeArray().eq(this.alternativeManager.from(other));
    }

    @Override
    public NDArray neq(Number n) {
        return this.getAlternativeArray().neq(n);
    }

    @Override
    public NDArray neq(NDArray other) {
        return this.getAlternativeArray().neq(this.alternativeManager.from(other));
    }

    @Override
    public NDArray gt(Number n) {
        return this.getAlternativeArray().gt(n);
    }

    @Override
    public NDArray gt(NDArray other) {
        return this.getAlternativeArray().gt(this.alternativeManager.from(other));
    }

    @Override
    public NDArray gte(Number n) {
        return this.getAlternativeArray().gte(n);
    }

    @Override
    public NDArray gte(NDArray other) {
        return this.getAlternativeArray().gte(this.alternativeManager.from(other));
    }

    @Override
    public NDArray lt(Number n) {
        return this.getAlternativeArray().lt(n);
    }

    @Override
    public NDArray lt(NDArray other) {
        return this.getAlternativeArray().lt(this.alternativeManager.from(other));
    }

    @Override
    public NDArray lte(Number n) {
        return this.getAlternativeArray().lte(n);
    }

    @Override
    public NDArray lte(NDArray other) {
        return this.getAlternativeArray().lte(this.alternativeManager.from(other));
    }

    @Override
    public NDArray add(Number n) {
        return this.getAlternativeArray().add(n);
    }

    @Override
    public NDArray add(NDArray other) {
        return this.getAlternativeArray().add(this.alternativeManager.from(other));
    }

    @Override
    public NDArray sub(Number n) {
        return this.getAlternativeArray().sub(n);
    }

    @Override
    public NDArray sub(NDArray other) {
        return this.getAlternativeArray().sub(this.alternativeManager.from(other));
    }

    @Override
    public NDArray mul(Number n) {
        return this.getAlternativeArray().mul(n);
    }

    @Override
    public NDArray mul(NDArray other) {
        return this.getAlternativeArray().mul(this.alternativeManager.from(other));
    }

    @Override
    public NDArray div(Number n) {
        return this.getAlternativeArray().div(n);
    }

    @Override
    public NDArray div(NDArray other) {
        return this.getAlternativeArray().div(this.alternativeManager.from(other));
    }

    @Override
    public NDArray mod(Number n) {
        return this.getAlternativeArray().mod(n);
    }

    @Override
    public NDArray mod(NDArray other) {
        return this.getAlternativeArray().mod(this.alternativeManager.from(other));
    }

    @Override
    public NDArray pow(Number n) {
        return this.getAlternativeArray().pow(n);
    }

    @Override
    public NDArray pow(NDArray other) {
        return this.getAlternativeArray().pow(this.alternativeManager.from(other));
    }

    @Override
    public NDArray addi(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray addi(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray subi(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray subi(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray muli(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray muli(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray divi(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray divi(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray modi(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray modi(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray powi(Number n) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray powi(NDArray other) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray sign() {
        return this.getAlternativeArray().sign();
    }

    @Override
    public NDArray signi() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray maximum(Number n) {
        return this.getAlternativeArray().maximum(n);
    }

    @Override
    public NDArray maximum(NDArray other) {
        return this.getAlternativeArray().maximum(this.alternativeManager.from(other));
    }

    @Override
    public NDArray minimum(Number n) {
        return this.getAlternativeArray().minimum(n);
    }

    @Override
    public NDArray minimum(NDArray other) {
        return this.getAlternativeArray().minimum(this.alternativeManager.from(other));
    }

    @Override
    public NDArray neg() {
        return this.getAlternativeArray().neg();
    }

    @Override
    public NDArray negi() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public NDArray abs() {
        return this.getAlternativeArray().abs();
    }

    @Override
    public NDArray square() {
        return this.getAlternativeArray().square();
    }

    @Override
    public NDArray sqrt() {
        return this.getAlternativeArray().sqrt();
    }

    @Override
    public NDArray cbrt() {
        return this.getAlternativeArray().cbrt();
    }

    @Override
    public NDArray floor() {
        return this.getAlternativeArray().floor();
    }

    @Override
    public NDArray ceil() {
        return this.getAlternativeArray().ceil();
    }

    @Override
    public NDArray round() {
        return this.getAlternativeArray().round();
    }

    @Override
    public NDArray trunc() {
        return this.getAlternativeArray().trunc();
    }

    @Override
    public NDArray exp() {
        return this.getAlternativeArray().exp();
    }

    @Override
    public NDArray gammaln() {
        return this.getAlternativeArray().gammaln();
    }

    @Override
    public NDArray log() {
        return this.getAlternativeArray().log();
    }

    @Override
    public NDArray log10() {
        return this.getAlternativeArray().log10();
    }

    @Override
    public NDArray log2() {
        return this.getAlternativeArray().log2();
    }

    @Override
    public NDArray sin() {
        return this.getAlternativeArray().sin();
    }

    @Override
    public NDArray cos() {
        return this.getAlternativeArray().cos();
    }

    @Override
    public NDArray tan() {
        return this.getAlternativeArray().tan();
    }

    @Override
    public NDArray asin() {
        return this.getAlternativeArray().asin();
    }

    @Override
    public NDArray acos() {
        return this.getAlternativeArray().acos();
    }

    @Override
    public NDArray atan() {
        return this.getAlternativeArray().atan();
    }

    @Override
    public NDArray atan2(NDArray other) {
        return this.getAlternativeArray().atan2(other);
    }

    @Override
    public NDArray sinh() {
        return this.getAlternativeArray().sinh();
    }

    @Override
    public NDArray cosh() {
        return this.getAlternativeArray().cosh();
    }

    @Override
    public NDArray tanh() {
        return this.getAlternativeArray().tanh();
    }

    @Override
    public NDArray asinh() {
        return this.getAlternativeArray().asinh();
    }

    @Override
    public NDArray acosh() {
        return this.getAlternativeArray().acosh();
    }

    @Override
    public NDArray atanh() {
        return this.getAlternativeArray().atanh();
    }

    @Override
    public NDArray toDegrees() {
        return this.getAlternativeArray().toDegrees();
    }

    @Override
    public NDArray toRadians() {
        return this.getAlternativeArray().toRadians();
    }

    @Override
    public NDArray max() {
        return this.getAlternativeArray().max();
    }

    @Override
    public NDArray max(int[] axes, boolean keepDims) {
        return this.getAlternativeArray().max(axes, keepDims);
    }

    @Override
    public NDArray min() {
        return this.getAlternativeArray().min();
    }

    @Override
    public NDArray min(int[] axes, boolean keepDims) {
        return this.getAlternativeArray().min(axes, keepDims);
    }

    @Override
    public NDArray sum() {
        return this.getAlternativeArray().sum();
    }

    @Override
    public NDArray sum(int[] axes, boolean keepDims) {
        return this.getAlternativeArray().sum(axes, keepDims);
    }

    @Override
    public NDArray cumProd(int axis) {
        return this.getAlternativeArray().cumProd(axis);
    }

    @Override
    public NDArray cumProd(int axis, DataType dataType) {
        return this.getAlternativeArray().cumProd(axis, dataType);
    }

    @Override
    public NDArray prod() {
        return this.getAlternativeArray().prod();
    }

    @Override
    public NDArray prod(int[] axes, boolean keepDims) {
        return this.getAlternativeArray().prod(axes, keepDims);
    }

    @Override
    public NDArray mean() {
        return this.getAlternativeArray().mean();
    }

    @Override
    public NDArray mean(int[] axes, boolean keepDims) {
        return this.getAlternativeArray().mean(axes, keepDims);
    }

    @Override
    public NDArray normalize(double p, long dim, double eps) {
        return this.getAlternativeArray().normalize(p, dim, eps);
    }

    @Override
    public NDArray rotate90(int times, int[] axes) {
        return this.getAlternativeArray().rotate90(times, axes);
    }

    @Override
    public NDArray trace(int offset, int axis1, int axis2) {
        return this.getAlternativeArray().trace(offset, axis1, axis2);
    }

    @Override
    public NDList split(long sections, int axis) {
        return this.getAlternativeArray().split(sections, axis);
    }

    @Override
    public NDList split(long[] indices, int axis) {
        return this.getAlternativeArray().split(indices, axis);
    }

    @Override
    public NDArray flatten() {
        return this.getAlternativeArray().flatten();
    }

    @Override
    public NDArray flatten(int startDim, int endDim) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray fft(long length, long axis) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray ifft(long length, long axis) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray rfft(long length, long axis) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray irfft(long length, long axis) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray stft(long nFft, long hopLength, boolean center, NDArray window, boolean normalize, boolean returnComplex) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray fft2(long[] sizes, long[] axes) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray pad(Shape padding, double value) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray ifft2(long[] sizes, long[] axes) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray reshape(Shape shape) {
        return this.getAlternativeArray().reshape(shape);
    }

    @Override
    public NDArray expandDims(int axis) {
        return this.getAlternativeArray().expandDims(axis);
    }

    @Override
    public NDArray squeeze(int[] axes) {
        return this.getAlternativeArray().squeeze(axes);
    }

    @Override
    public NDList unique(Integer dim, boolean sorted, boolean returnInverse, boolean returnCounts) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray logicalAnd(NDArray other) {
        return this.getAlternativeArray().logicalAnd(this.alternativeManager.from(other));
    }

    @Override
    public NDArray logicalOr(NDArray other) {
        return this.getAlternativeArray().logicalOr(this.alternativeManager.from(other));
    }

    @Override
    public NDArray logicalXor(NDArray other) {
        return this.getAlternativeArray().logicalXor(this.alternativeManager.from(other));
    }

    @Override
    public NDArray logicalNot() {
        return this.getAlternativeArray().logicalNot();
    }

    @Override
    public NDArray argSort(int axis, boolean ascending) {
        return this.getAlternativeArray().argSort(axis, ascending);
    }

    @Override
    public NDArray sort() {
        return this.getAlternativeArray().sort();
    }

    @Override
    public NDArray sort(int axis) {
        return this.getAlternativeArray().sort(axis);
    }

    @Override
    public NDArray softmax(int axis) {
        return this.getAlternativeArray().softmax(axis);
    }

    @Override
    public NDArray logSoftmax(int axis) {
        return this.getAlternativeArray().logSoftmax(axis);
    }

    @Override
    public NDArray cumSum() {
        return this.getAlternativeArray().cumSum();
    }

    @Override
    public NDArray cumSum(int axis) {
        return this.getAlternativeArray().cumSum(axis);
    }

    @Override
    public NDArray diagonal() {
        return this.getAlternativeArray().diagonal(0);
    }

    @Override
    public NDArray diagonal(int offset) {
        return this.getAlternativeArray().diagonal(offset);
    }

    @Override
    public NDArray diagonal(int offset, int axis1, int axis2) {
        return this.getAlternativeArray().diagonal(offset, axis1, axis2);
    }

    @Override
    public NDArray isInfinite() {
        return this.getAlternativeArray().isInfinite();
    }

    @Override
    public NDArray isNaN() {
        return this.getAlternativeArray().isNaN();
    }

    @Override
    public NDArray tile(long repeats) {
        return this.getAlternativeArray().tile(repeats);
    }

    @Override
    public NDArray tile(int axis, long repeats) {
        return this.getAlternativeArray().tile(axis, repeats);
    }

    @Override
    public NDArray tile(long[] repeats) {
        return this.getAlternativeArray().tile(repeats);
    }

    @Override
    public NDArray tile(Shape desiredShape) {
        return this.getAlternativeArray().tile(desiredShape);
    }

    @Override
    public NDArray repeat(long repeats) {
        return this.getAlternativeArray().repeat(repeats);
    }

    @Override
    public NDArray repeat(int axis, long repeats) {
        return this.getAlternativeArray().repeat(axis, repeats);
    }

    @Override
    public NDArray repeat(long[] repeats) {
        return this.getAlternativeArray().repeat(repeats);
    }

    @Override
    public NDArray repeat(Shape desiredShape) {
        return this.getAlternativeArray().repeat(desiredShape);
    }

    @Override
    public NDArray dot(NDArray other) {
        return this.getAlternativeArray().dot(other);
    }

    @Override
    public NDArray matMul(NDArray other) {
        return this.getAlternativeArray().matMul(other);
    }

    @Override
    public NDArray batchMatMul(NDArray other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NDArray xlogy(NDArray other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NDArray clip(Number min, Number max) {
        return this.getAlternativeArray().clip(min, max);
    }

    @Override
    public NDArray flip(int ... axes) {
        return this.getAlternativeArray().flip(axes);
    }

    @Override
    public NDArray transpose() {
        return this.getAlternativeArray().transpose();
    }

    @Override
    public NDArray transpose(int ... axes) {
        return this.getAlternativeArray().transpose(axes);
    }

    @Override
    public NDArray broadcast(Shape shape) {
        return this.getAlternativeArray().broadcast(shape);
    }

    @Override
    public NDArray argMax() {
        return this.getAlternativeArray().argMax();
    }

    @Override
    public NDArray argMax(int axis) {
        return this.getAlternativeArray().argMax(axis);
    }

    @Override
    public NDList topK(int k, int axis, boolean largest, boolean sorted) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray argMin() {
        return this.getAlternativeArray().argMin();
    }

    @Override
    public NDArray argMin(int axis) {
        return this.getAlternativeArray().argMin(axis);
    }

    @Override
    public NDArray percentile(Number percentile) {
        return this.getAlternativeArray().percentile(percentile);
    }

    @Override
    public NDArray percentile(Number percentile, int[] axes) {
        return this.getAlternativeArray().percentile(percentile, axes);
    }

    @Override
    public NDArray median() {
        return this.getAlternativeArray().median();
    }

    @Override
    public NDArray median(int[] axes) {
        return this.getAlternativeArray().median(axes);
    }

    @Override
    public NDArray toDense() {
        return this.getAlternativeArray().toDense();
    }

    @Override
    public NDArray toSparse(SparseFormat fmt) {
        return this.getAlternativeArray().toSparse(fmt);
    }

    @Override
    public NDArray nonzero() {
        return this.getAlternativeArray().nonzero();
    }

    @Override
    public NDArray erfinv() {
        return this.getAlternativeArray().erfinv();
    }

    @Override
    public NDArray erf() {
        return this.getAlternativeArray().erf();
    }

    @Override
    public NDArray inverse() {
        return this.getAlternativeArray().inverse();
    }

    @Override
    public NDArray norm(boolean keepDims) {
        return this.getAlternativeArray().norm(keepDims);
    }

    @Override
    public NDArray norm(int ord, int[] axes, boolean keepDims) {
        return this.getAlternativeArray().norm(ord, axes, keepDims);
    }

    @Override
    public NDArray oneHot(int depth, float onValue, float offValue, DataType dataType) {
        return this.getAlternativeArray().oneHot(depth, onValue, offValue, dataType);
    }

    @Override
    public NDArray batchDot(NDArray other) {
        return this.getAlternativeArray().batchDot(this.alternativeManager.from(other));
    }

    @Override
    public NDArray complex() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray real() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray conj() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArray diff(int n, int dim) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public NDArrayEx getNDArrayInternal() {
        NDArray array = this.getAlternativeArray();
        if (array instanceof NDArrayAdapter) {
            throw new UnsupportedOperationException("Operation not supported.");
        }
        return array.getNDArrayInternal();
    }

    @Override
    public boolean isReleased() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.manager.detachInternal(this.getUid());
            this.isClosed = true;
            if (this.alternativeArray != null) {
                this.alternativeArray.close();
                this.alternativeArray = null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NDArray) {
            return this.contentEquals((NDArray)obj);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        if (this.isClosed) {
            return "This array is already closed";
        }
        return this.toDebugString();
    }

    private NDArray getAlternativeArray() {
        if (this.alternativeManager == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        if (this.alternativeArray == null) {
            this.alternativeArray = this.alternativeManager.from(this);
        } else {
            this.alternativeArray.set(this.getDataType().asDataType(this.toByteBuffer()));
        }
        NDScope.unregister(this.alternativeArray);
        return this.alternativeArray;
    }
}

