/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.embedding;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.modality.nlp.embedding.TextEmbedding;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.nn.core.Embedding;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoopTranslator;
import ai.djl.translate.TranslateException;
import java.util.List;

public class ModelZooTextEmbedding
implements TextEmbedding,
AutoCloseable {
    private Predictor<NDList, NDList> predictor;
    private Embedding<String> embedding;

    public ModelZooTextEmbedding(Model model) {
        this.predictor = model.newPredictor(new NoopTranslator(Batchifier.STACK));
        try {
            this.embedding = (Embedding)model.getBlock();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The model was not an embedding", e);
        }
    }

    @Override
    public long[] preprocessTextToEmbed(List<String> tokens) {
        return tokens.stream().mapToLong(this.embedding::embed).toArray();
    }

    @Override
    public NDArray embedText(NDArray indices) throws EmbeddingException {
        try {
            return this.predictor.predict(new NDList(indices)).singletonOrThrow();
        }
        catch (TranslateException e) {
            throw new EmbeddingException("Could not embed word", e);
        }
    }

    @Override
    public List<String> unembedText(NDArray word) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        this.predictor.close();
    }
}

