/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.VisionLanguageInput;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;

public class ZeroShotObjectDetectionServingTranslator
implements NoBatchifyTranslator<Input, Output> {
    private Translator<VisionLanguageInput, DetectedObjects> translator;

    public ZeroShotObjectDetectionServingTranslator(Translator<VisionLanguageInput, DetectedObjects> translator) {
        this.translator = translator;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        if (input.getContent().isEmpty()) {
            throw new TranslateException("Input data is empty.");
        }
        VisionLanguageInput prompt = VisionLanguageInput.parseInput(input);
        NDList ret = this.translator.processInput(ctx, prompt);
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            NDList[] batch = new NDList[]{ret};
            return batchifier.batchify(batch);
        }
        return ret;
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        output.addProperty("Content-Type", "application/json");
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            list = batchifier.unbatchify(list)[0];
        }
        output.add(BytesSupplier.wrapAsJson(this.translator.processOutput(ctx, list)));
        return output;
    }
}

