/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.VisionLanguageInput;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.YoloWorldTranslator;
import ai.djl.modality.cv.translator.ZeroShotObjectDetectionServingTranslator;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class YoloWorldTranslatorFactory
implements TranslatorFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        YoloWorldTranslator translator = YoloWorldTranslator.builder(arguments).build();
        if (input == VisionLanguageInput.class && output == DetectedObjects.class) {
            return translator;
        }
        if (input == Input.class && output == Output.class) {
            return new ZeroShotObjectDetectionServingTranslator(translator);
        }
        throw new IllegalArgumentException("Unsupported input/output types.");
    }

    static {
        SUPPORTED_TYPES.add(new Pair<Class<VisionLanguageInput>, Class<DetectedObjects>>(VisionLanguageInput.class, DetectedObjects.class));
        SUPPORTED_TYPES.add(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }
}

