/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine.rpc;

import ai.djl.engine.rpc.RpcClient;
import ai.djl.engine.rpc.TypeConverter;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.NDList;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;

public class RpcTranslator<I, O>
implements NoBatchifyTranslator<I, O> {
    private RpcClient client;
    private TypeConverter<I, O> converter;

    protected RpcTranslator(RpcClient client, TypeConverter<I, O> converter) {
        this.client = client;
        this.converter = converter;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, I input) throws IOException {
        Input in = this.converter.toInput(input);
        Output output = this.client.send(in);
        ctx.setAttachment("output", output);
        return new NDList();
    }

    @Override
    public O processOutput(TranslatorContext ctx, NDList list) throws TranslateException {
        Output output = (Output)ctx.getAttachment("output");
        return this.converter.fromOutput(output);
    }
}

