/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.util.Xml;
import cn.com.mma.mobile.tracking.bean.Argument;
import cn.com.mma.mobile.tracking.bean.Company;
import cn.com.mma.mobile.tracking.bean.Config;
import cn.com.mma.mobile.tracking.bean.Domain;
import cn.com.mma.mobile.tracking.bean.Event;
import cn.com.mma.mobile.tracking.bean.OfflineCache;
import cn.com.mma.mobile.tracking.bean.SDK;
import cn.com.mma.mobile.tracking.bean.Signature;
import cn.com.mma.mobile.tracking.bean.Switch;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class XmlUtil {
    public static final String XMLFILE = "sdkconfig.xml";

    public static SDK doParser(InputStream inputStream) {
        SDK sdk = null;
        Argument argument = null;
        Company company = null;
        Event event = null;
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(inputStream, "UTF-8");
            int _event = parser.getEventType();
            while (_event != 1) {
                switch (_event) {
                    case 0: {
                        sdk = new SDK();
                        break;
                    }
                    case 2: {
                        String elementName = parser.getName();
                        if ("offlineCache".equals(elementName)) {
                            sdk.offlineCache = new OfflineCache();
                        }
                        if (sdk.offlineCache != null) {
                            if ("length".equals(elementName)) {
                                sdk.offlineCache.length = parser.nextText();
                            }
                            if ("queueExpirationSecs".equals(elementName)) {
                                sdk.offlineCache.queueExpirationSecs = parser.nextText();
                            }
                            if ("timeout".equals(elementName)) {
                                sdk.offlineCache.timeout = parser.nextText();
                            }
                        }
                        if ("companies".equals(elementName)) {
                            sdk.companies = new ArrayList<Company>();
                        }
                        if (sdk.companies != null && "company".equals(elementName)) {
                            company = new Company();
                        }
                        if (company == null) break;
                        if ("name".equals(elementName) && company.name == null) {
                            company.name = parser.nextText();
                        }
                        if ("domain".equals(elementName)) {
                            company.domain = new Domain();
                        }
                        if (company.domain != null && "url".equals(elementName)) {
                            company.domain.url = parser.nextText();
                        }
                        if ("signature".equals(elementName)) {
                            company.signature = new Signature();
                        }
                        if (company.signature != null) {
                            if ("publicKey".equals(elementName)) {
                                company.signature.publicKey = parser.nextText();
                            }
                            if ("paramKey".equals(elementName)) {
                                company.signature.paramKey = parser.nextText();
                            }
                        }
                        if ("switch".equals(elementName)) {
                            company.sswitch = new Switch();
                        }
                        if (company.sswitch != null) {
                            if ("isTrackLocation".equals(elementName)) {
                                company.sswitch.isTrackLocation = Boolean.parseBoolean(parser.nextText());
                            }
                            if ("offlineCacheExpiration".equals(elementName)) {
                                company.sswitch.offlineCacheExpiration = parser.nextText();
                            }
                            if ("encrypt".equals(elementName)) {
                                company.sswitch.encrypt = new HashMap<String, String>();
                            }
                            if (company.sswitch.encrypt != null && ("MAC".equals(elementName) || "IDA".equals(elementName) || "IMEI".equals(elementName) || "ANDROID".equals(elementName))) {
                                company.sswitch.encrypt.put(elementName, parser.nextText());
                            }
                        }
                        if ("config".equals(elementName)) {
                            company.config = new Config();
                        }
                        if (company.config != null) {
                            if ("arguments".equals(elementName)) {
                                company.config.arguments = new ArrayList<Argument>();
                            }
                            if (company.config.arguments != null && "argument".equals(elementName)) {
                                argument = new Argument();
                            }
                            if (argument != null) {
                                if ("key".equals(elementName)) {
                                    argument.key = parser.nextText();
                                }
                                if ("value".equals(elementName)) {
                                    argument.value = parser.nextText();
                                }
                                if ("urlEncode".equals(elementName)) {
                                    argument.urlEncode = Boolean.parseBoolean(parser.nextText());
                                }
                                if ("isRequired".equals(elementName)) {
                                    argument.isRequired = Boolean.parseBoolean(parser.nextText());
                                }
                            }
                            if ("events".equals(elementName)) {
                                company.config.events = new ArrayList<Event>();
                            }
                            if (company.config.events != null && "event".equals(elementName)) {
                                event = new Event();
                            }
                            if (event != null) {
                                if ("key".equals(elementName)) {
                                    event.key = parser.nextText();
                                }
                                if ("value".equals(elementName)) {
                                    event.value = parser.nextText();
                                }
                                if ("urlEncode".equals(elementName)) {
                                    event.urlEncode = Boolean.parseBoolean(parser.nextText());
                                }
                            }
                        }
                        if ("separator".equals(elementName)) {
                            company.separator = parser.nextText();
                        }
                        if ("equalizer".equals(elementName)) {
                            company.equalizer = parser.nextText();
                        }
                        if (!"timeStampUseSecond".equals(elementName)) break;
                        company.timeStampUseSecond = Boolean.parseBoolean(parser.nextText());
                        break;
                    }
                    case 3: {
                        String endElement = parser.getName();
                        if ("company".equals(endElement)) {
                            sdk.companies.add(company);
                            company = null;
                        }
                        if ("argument".equals(endElement)) {
                            company.config.arguments.add(argument);
                            argument = null;
                        }
                        if (!"event".equals(endElement)) break;
                        company.config.events.add(event);
                        event = null;
                    }
                }
                _event = parser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdk;
    }
}

