/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.text.TextUtils;
import cn.com.mma.mobile.tracking.api.Constant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ConnectUtil {
    private static ConnectUtil instance = null;
    private String userAgentStr = null;

    private ConnectUtil() {
    }

    public static ConnectUtil getInstance() {
        if (instance == null) {
            instance = new ConnectUtil();
        }
        return instance;
    }

    public void setUserAgent(String ua) {
        this.userAgentStr = ua;
    }

    public String post(String url, Map<String, String> params, boolean addTokenId, boolean userGZip) {
        HttpPost httpost = null;
        try {
            httpost = new HttpPost(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            nvps.add(new BasicNameValuePair(key, value));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
        catch (UnsupportedEncodingException entry) {
            // empty catch block
        }
        String strRet = this.execute((HttpClient)this.getClient(), (HttpUriRequest)httpost, addTokenId, userGZip, false);
        return strRet;
    }

    public String postJson(String url, String encoderJson) {
        HttpPost httpost = null;
        String strRet = null;
        try {
            httpost = new HttpPost(url);
            httpost.addHeader("Content-Type", Constant.APPLICATION_JSON);
            StringEntity se = new StringEntity(encoderJson);
            se.setContentType(Constant.CONTENT_TYPE_TEXT_JSON);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", Constant.APPLICATION_JSON));
            httpost.setEntity((HttpEntity)se);
            strRet = this.execute((HttpClient)this.getClient(), (HttpUriRequest)httpost, false, false, true);
        }
        catch (Exception e) {
            strRet = null;
        }
        return strRet;
    }

    public String get(String url, boolean addUserInfo, boolean usingGZip, boolean status) {
        String s = "";
        try {
            HttpGet httpget = new HttpGet(url);
            s = this.execute((HttpClient)this.getClient(), (HttpUriRequest)httpget, addUserInfo, usingGZip, status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public String get(String url) {
        return this.get(url, false, false, false);
    }

    public String getForStatus(String url) {
        return this.get(url, false, false, true);
    }

    public String getRedirect(String url) {
        return this.get(url, false, false, false);
    }

    public boolean downloadFile(String fileUrl, String folderPath, String saveFilePath) {
        try {
            HttpGet httpget = new HttpGet(fileUrl);
            return this.execute((HttpClient)this.getClient(), (HttpUriRequest)httpget, folderPath, saveFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String post(String url, boolean addUserInfo, boolean usingGZip) {
        String s = "";
        try {
            HttpGet httpget = new HttpGet(url);
            s = this.execute((HttpClient)this.getClient(), (HttpUriRequest)httpget, addUserInfo, usingGZip, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is), 8192);
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
                line = null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public DefaultHttpClient getClient() {
        DefaultHttpClient httpClient = null;
        BasicHttpParams httpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)Constant.OFFLINECACHE_TIMEOUT);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(Constant.DEFAULT_MAX_CONNECTIONS));
        ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)Constant.DEFAULT_MAX_CONNECTIONS);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)(Constant.OFFLINECACHE_TIMEOUT * 1000));
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)(Constant.OFFLINECACHE_TIMEOUT * 1000));
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)Constant.DEFAULT_SOCKET_BUFFER_SIZE);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)this.userAgentStr);
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
        httpParams.setParameter("http.protocol.handle-redirects", (Object)Boolean.FALSE);
        httpParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        return httpClient;
    }

    public InputStream getInputStream(String url) {
        DefaultHttpClient httpclient = this.getClient();
        try {
            HttpEntity entity;
            HttpGet httpget = new HttpGet(url);
            HttpResponse response = null;
            response = httpclient.execute((HttpUriRequest)httpget);
            if (response != null && response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                return entity.getContent();
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String execute(HttpClient httpclient, HttpUriRequest req, boolean addUserInfo, boolean usingZip, boolean status) {
        String result;
        block39: {
            result = "";
            HttpResponse response = null;
            InputStream instream = null;
            try {
                if (usingZip) {
                    req.addHeader("Accept-Encoding", "gzip");
                }
                if ((response = httpclient.execute(req)) == null) {
                    return null;
                }
                HttpEntity entity = response.getEntity();
                String statusCode = response.getStatusLine().toString();
                if (status) {
                    String string = statusCode;
                    return string;
                }
                try {
                    Header contentEncoding = response.getFirstHeader("Content-Encoding");
                    if (entity != null) {
                        instream = entity.getContent();
                        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                            GZIPInputStream is = new GZIPInputStream(instream);
                            instream = null;
                            instream = is;
                        }
                        result = this.convertStreamToString(instream);
                        break block39;
                    }
                    result = statusCode;
                }
                catch (ConnectTimeoutException e) {
                    e.printStackTrace();
                    result = null;
                }
                catch (SocketTimeoutException e) {
                    e.printStackTrace();
                    result = null;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    result = null;
                }
                catch (ClientProtocolException e) {
                    e.printStackTrace();
                    result = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    result = null;
                }
            }
            finally {
                try {
                    if (instream != null) {
                        instream.close();
                        instream = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    result = null;
                }
            }
        }
        return result;
    }

    private String executeForRedirect(HttpClient httpclient, HttpUriRequest req, boolean addUserInfo, boolean usingZip, boolean status) {
        String result = "";
        HttpResponse response = null;
        InputStream instream = null;
        try {
            if (usingZip) {
                req.addHeader("Accept-Encoding", "gzip");
            }
            if ((response = httpclient.execute(req)) == null) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            String statusCode = response.getStatusLine().toString();
            Header[] headers = response.getHeaders("Location");
            if (headers != null && headers.length > 0) {
                String redirectUrl = headers[0].getValue();
                if (!TextUtils.isEmpty((CharSequence)redirectUrl)) {
                    String string = redirectUrl;
                    return string;
                }
                String string = statusCode;
                return string;
            }
            String string = statusCode;
            return string;
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
            result = null;
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            result = null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            result = null;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            result = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = null;
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                    instream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    private boolean execute(HttpClient httpclient, HttpUriRequest req, String saveFolder, String saveFilePath) {
        HttpResponse response = null;
        InputStream instream = null;
        try {
            response = httpclient.execute(req);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                if (instream == null) {
                    return false;
                }
                File path = new File(saveFolder);
                if (!path.exists()) {
                    path.mkdirs();
                }
                File pathZip = new File(saveFilePath);
                pathZip.createNewFile();
                FileOutputStream fos = new FileOutputStream(pathZip);
                byte[] buffer = new byte[1024];
                int i = -1;
                while ((i = instream.read(buffer)) != -1) {
                    fos.write(buffer, 0, i);
                }
                fos.flush();
                if (fos != null) {
                    fos.close();
                }
                return true;
            }
            return false;
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
            return false;
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                    instream = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

