/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.api;

import android.content.Context;
import android.text.TextUtils;
import cn.com.mma.mobile.tracking.api.Countly;
import cn.com.mma.mobile.tracking.util.ConnectUtil;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.com.mma.mobile.tracking.util.SharedPreferencedUtil;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class SendMessageThread
extends Thread {
    private String spName;
    private Context context;
    private boolean isNormalList;
    private boolean isInterruptThread = false;
    public int totalSize = 0;
    ConnectUtil connectUtil = null;
    private Object object = null;
    private Countly instance;
    private boolean isRunning = true;

    @Override
    public void interrupt() {
        this.isInterruptThread = true;
        super.interrupt();
    }

    SendMessageThread(String spFileName, Context context, boolean isNormalList) {
        this.spName = spFileName;
        this.context = context;
        this.isNormalList = isNormalList;
        this.connectUtil = ConnectUtil.getInstance();
        this.object = new Object();
        this.instance = Countly.sharedInstance();
    }

    @Override
    public synchronized void run() {
        this.sendData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendData() {
        Object object = this.object;
        synchronized (object) {
            Set set = SharedPreferencedUtil.getSharedPreferences(this.context, this.spName).getAll().keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (this.isInterruptThread) {
                    return;
                }
                Long valueExpire = null;
                String key = null;
                try {
                    key = (String)iterator.next();
                    valueExpire = SharedPreferencedUtil.getLong(this.context, this.spName, key);
                    long failedTime = SharedPreferencedUtil.getLong(this.context, "cn.com.mma.mobile.tracking.other", key);
                    String data = key;
                    if (TextUtils.isEmpty((CharSequence)data)) continue;
                    if (valueExpire > System.currentTimeMillis()) {
                        HttpResponse httpResponse;
                        HashSet<String> requestList = this.instance.getHashSet();
                        if (requestList != null) {
                            if (requestList.contains(data)) {
                                return;
                            }
                            requestList.add(data);
                        }
                        if ((httpResponse = this.sendMessage(data)) == null) {
                            this.handleFailedResult(key, valueExpire);
                            return;
                        }
                        int statueCode = httpResponse.getStatusLine().getStatusCode();
                        if (statueCode == 200 || statueCode == 302 || statueCode == 301) {
                            String redirectUrl;
                            Header[] headers;
                            this.handleSuccessResult(this.spName, key);
                            if (statueCode != 302 && statueCode != 301 || (headers = httpResponse.getHeaders("Location")) == null || headers.length <= 0 || (redirectUrl = headers[0].getValue()) == null) continue;
                            this.connectUtil.get(redirectUrl);
                            continue;
                        }
                        this.handleFailedResult(key, valueExpire);
                        continue;
                    }
                    SharedPreferencedUtil.removeFromSharedPreferences(this.context, this.spName, key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isRunning = false;
        }
    }

    private HttpResponse sendMessage(String data) {
        DefaultHttpClient httpClient = null;
        HttpGet method = null;
        HttpResponse httpResponse = null;
        long time1 = System.currentTimeMillis();
        try {
            try {
                httpClient = new DefaultHttpClient();
                method = new HttpGet(new URI(data));
                BasicHttpParams hp = new BasicHttpParams();
                hp.setParameter("http.connection.timeout", (Object)10000);
                hp.setParameter("http.socket.timeout", (Object)10000);
                httpClient.setParams((HttpParams)hp);
                DefaultHttpRequestRetryHandler handler = new DefaultHttpRequestRetryHandler(0, false);
                httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)handler);
                httpClient.setRedirectHandler(new RedirectHandler(){

                    public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
                        return false;
                    }

                    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
                        return null;
                    }
                });
                httpResponse = httpClient.execute((HttpUriRequest)method);
            }
            catch (Exception e) {
                e.printStackTrace();
                httpResponse = null;
                Logger.d("mma_result_error\u53d1\u9001\u5931\u8d25");
                if (httpClient != null && httpClient.getConnectionManager() != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
        }
        finally {
            if (httpClient != null && httpClient.getConnectionManager() != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return httpResponse;
    }

    private void handleFailedResult(String key, long valueExpire) {
        if (this.isNormalList) {
            SharedPreferencedUtil.removeFromSharedPreferences(this.context, "cn.com.mma.mobile.tracking.normal", key);
            SharedPreferencedUtil.putLong(this.context, "cn.com.mma.mobile.tracking.falied", key, valueExpire);
            SharedPreferencedUtil.putLong(this.context, "cn.com.mma.mobile.tracking.other", key, 1L);
        } else {
            long failedTime = SharedPreferencedUtil.getLong(this.context, "cn.com.mma.mobile.tracking.other", key);
            if (++failedTime > 3L) {
                SharedPreferencedUtil.removeFromSharedPreferences(this.context, "cn.com.mma.mobile.tracking.falied", key);
                boolean result = SharedPreferencedUtil.removeFromSharedPreferences(this.context, "cn.com.mma.mobile.tracking.other", key);
                Logger.d("mma_failed\u53d1\u9001\u5931\u8d25\u8d85\u8fc7\u4e09\u6b21\uff0c\u5220\u9664other\u4e2d\u8bb0\u5f55" + result);
            } else {
                SharedPreferencedUtil.putLong(this.context, "cn.com.mma.mobile.tracking.other", key, failedTime);
            }
        }
        try {
            HashSet<String> requestList = this.instance.getHashSet();
            requestList.remove(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleSuccessResult(String sharedPreferencedName, String key) {
        SharedPreferencedUtil.removeFromSharedPreferences(this.context, sharedPreferencedName, key);
        if (!this.isNormalList) {
            boolean result = SharedPreferencedUtil.removeFromSharedPreferences(this.context, "cn.com.mma.mobile.tracking.other", key);
            Logger.d("mma_failed\u6570\u636e\u53d1\u9001\u6210\u529f\uff0c\u5220\u9664other\u4e2d\u8bb0\u5f55" + result);
        }
        try {
            HashSet<String> requestList = this.instance.getHashSet();
            requestList.remove(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

