/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.disLike;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupWindowLayout;
import ai.botbrain.ttcloud.sdk.disLike.ScreenUtils;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;

public class FitPopupWindow
extends PopupWindow
implements PopupWindow.OnDismissListener {
    private View anchorView;
    private Activity context;
    private int mWindowWidth;
    private static final int PADDING = 0;
    private int mXCoordinate;
    private int mHorizontal;
    private int mVertical;
    private int[] windowPos;
    private FitPopupWindowLayout mFitPopupWindowLayout;

    public FitPopupWindow(Activity context) {
        this.init(context, -2, -2);
    }

    public FitPopupWindow(Activity context, int width, int height) {
        this.mWindowWidth = width;
        this.init(context, width, height);
    }

    private void init(Activity context, int width, int height) {
        this.context = context;
        this.setWidth(width);
        this.setHeight(height);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setOutsideTouchable(true);
        this.setFocusable(true);
        this.setOnDismissListener(this);
        this.setAnimationStyle(R.style.tpp_popp_anim);
    }

    public void setView(View contentView, View anchorView) {
        this.anchorView = anchorView;
        this.windowPos = this.calculatePopWindowPos(anchorView, contentView);
        this.mFitPopupWindowLayout = new FitPopupWindowLayout((Context)this.context);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.getHeight() - 50);
        layoutParams.bottomMargin = 50;
        contentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mFitPopupWindowLayout.setOrientation(this.getHorizontal(), this.getVertical(), this.getXCoordinate());
        this.mFitPopupWindowLayout.addView(contentView);
        this.setContentView((View)this.mFitPopupWindowLayout);
    }

    public void show() {
        this.showAtLocation(this.anchorView, 8388661, this.windowPos[0], this.windowPos[1]);
        this.update();
        Window window = this.context.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.alpha = 0.7f;
        window.setAttributes(lp);
    }

    protected int[] calculatePopWindowPos(View anchorView, View contentView) {
        int[] windowPos = new int[2];
        int[] anchorLoc = new int[2];
        anchorView.getLocationOnScreen(anchorLoc);
        int anchorHeight = anchorView.getHeight();
        int anchorWidth = anchorView.getWidth();
        this.mXCoordinate = anchorLoc[0];
        int screenHeight = ScreenUtils.getScreenHeight(anchorView.getContext());
        int screenWidth = ScreenUtils.getScreenWidth(anchorView.getContext());
        contentView.measure(0, 0);
        int windowHeight = contentView.getMeasuredHeight();
        this.mWindowWidth = this.mWindowWidth > 0 ? this.mWindowWidth : contentView.getMeasuredWidth();
        boolean isNeedShowUp = screenHeight - anchorLoc[1] - anchorHeight < screenHeight / 2;
        boolean isNeedShowLeft = anchorLoc[0] < this.mWindowWidth / 2;
        this.setHorizontal(isNeedShowLeft ? 3 : 2);
        this.setVertical(isNeedShowUp ? 1 : 4);
        windowPos[0] = (screenWidth - this.mWindowWidth) / 2;
        windowPos[1] = isNeedShowUp ? anchorLoc[1] - windowHeight - 0 - 50 : anchorLoc[1] + anchorHeight + 0;
        return windowPos;
    }

    public void dismiss() {
        super.dismiss();
    }

    public void onDismiss() {
        WindowManager.LayoutParams lp = this.context.getWindow().getAttributes();
        lp.alpha = 1.0f;
        this.context.getWindow().setAttributes(lp);
    }

    public int getXCoordinate() {
        if (this.mXCoordinate > this.mWindowWidth / 2) {
            this.mXCoordinate = this.mWindowWidth - this.mXCoordinate - this.anchorView.getWidth() + 50;
        }
        return this.mXCoordinate;
    }

    private int getHorizontal() {
        return this.mHorizontal;
    }

    private void setHorizontal(int mHorizontal) {
        this.mHorizontal = mHorizontal;
    }

    private int getVertical() {
        return this.mVertical;
    }

    private void setVertical(int mVertical) {
        this.mVertical = mVertical;
    }

    private void startAnimation(boolean isStart) {
        AnimationSet animationSet = new AnimationSet(true);
        ScaleAnimation sa = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        sa.setDuration(150L);
        sa.setInterpolator((Interpolator)new FastOutSlowInInterpolator());
        sa.setFillAfter(true);
        AlphaAnimation aa = new AlphaAnimation(0.0f, 1.0f);
        aa.setDuration(150L);
        aa.setFillAfter(true);
        animationSet.addAnimation((Animation)sa);
        animationSet.addAnimation((Animation)aa);
        this.mFitPopupWindowLayout.startAnimation((Animation)animationSet);
    }
}

