/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.colorUi.widget;

import ai.botbrain.ttcloud.sdk.colorUi.ColorUiInterface;
import ai.botbrain.ttcloud.sdk.colorUi.util.ViewAttributeUtil;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

public class ColorTextView
extends TextView
implements ColorUiInterface {
    private int attr_drawable = -1;
    private int attr_textAppearance = -1;
    private int attr_textColor = -1;

    public ColorTextView(Context context) {
        super(context);
    }

    public ColorTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.attr_drawable = ViewAttributeUtil.getBackgroundAttibute(attrs);
        this.attr_textColor = ViewAttributeUtil.getTextColorAttribute(attrs);
    }

    public ColorTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attr_drawable = ViewAttributeUtil.getBackgroundAttibute(attrs);
        this.attr_textColor = ViewAttributeUtil.getTextColorAttribute(attrs);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void setTheme(Resources.Theme themeId) {
        Log.d((String)"COLOR", (String)("id = " + this.getId()));
        if (this.attr_drawable != -1) {
            ViewAttributeUtil.applyBackgroundDrawable(this, themeId, this.attr_drawable);
        }
        if (this.attr_textColor != -1) {
            ViewAttributeUtil.applyTextColor(this, themeId, this.attr_textColor);
        }
    }
}

