/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;
import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import java.util.List;

public class SubCommentAdapter
extends BaseAdapter
implements View.OnClickListener {
    private Context mContext;
    private List<SubCommentEntity> mDatas;
    private RequestOptions options_avatar = new RequestOptions().centerCrop().error(R.drawable.tsd_def_avatar).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC).skipMemoryCache(false).priority(Priority.HIGH);

    public SubCommentAdapter(Context context, List<SubCommentEntity> datas) {
        this.mContext = context;
        this.mDatas = datas;
    }

    public int getCount() {
        return null == this.mDatas ? 0 : this.mDatas.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_sub_comment, null);
            viewHolder.iv_avatar = (TsdCircleImageView)convertView.findViewById(R.id.iv_avatar);
            viewHolder.tv_user_nick = (TextView)convertView.findViewById(R.id.tv_user_nick);
            viewHolder.tv_content = (TextView)convertView.findViewById(R.id.tv_content);
            viewHolder.tv_time = (TextView)convertView.findViewById(R.id.tv_time);
            viewHolder.tv_reply = (TextView)convertView.findViewById(R.id.tv_reply);
            viewHolder.tv_reply.setOnClickListener((View.OnClickListener)this);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        viewHolder.tv_reply.setTag((Object)position);
        SubCommentEntity data = this.mDatas.get(position);
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        String parentNick = null == data.parentNick ? "" : data.parentNick;
        String parentCommentContent = null == data.parentCommentContent ? "" : data.parentCommentContent;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);
        viewHolder.tv_user_nick.setText((CharSequence)userNick);
        if (TextUtils.isEmpty((CharSequence)parentCommentContent)) {
            viewHolder.tv_content.setText((CharSequence)commentContent);
        } else {
            viewHolder.tv_content.setText((CharSequence)Html.fromHtml((String)(commentContent + " //" + "<font color='#215a94'>" + "@" + parentNick + "</font>" + "\uff1a" + parentCommentContent)));
        }
        viewHolder.tv_time.setText((CharSequence)commentTime);
        Glide.with((Context)TsdContextHolder.getContext()).setDefaultRequestOptions(this.options_avatar).load((Object)userIcon).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into((ImageView)viewHolder.iv_avatar);
        return convertView;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_reply) {
            int position = (Integer)v.getTag();
            this.clickReply(v, position);
        }
    }

    private void clickReply(View v, int position) {
        if (!TsdContextHolder.isLogin()) {
            TsdContextHolder.getTtCloudListener().onComment(v, null, null);
            return;
        }
        TsdH5ReaderActivity h5ReaderActivity = (TsdH5ReaderActivity)this.mContext;
        SubCommentEntity data = this.mDatas.get(position);
        SubCommEntity subCommEntity = new SubCommEntity();
        subCommEntity.parentId = data.userId;
        subCommEntity.parentIcon = data.userAvatar;
        subCommEntity.parentCommentId = data.id;
        subCommEntity.parentNick = data.userNickName;
        subCommEntity.parentCommentContent = data.commentContent;
        subCommEntity.superiorCommentId = h5ReaderActivity.mSubCommentsWidget.id;
        h5ReaderActivity.setSubCommEntity(subCommEntity);
        h5ReaderActivity.showInputDialog();
    }

    private static class ViewHolder {
        TsdCircleImageView iv_avatar;
        TextView tv_user_nick;
        TextView tv_content;
        TextView tv_time;
        TextView tv_reply;

        private ViewHolder() {
        }
    }
}

