/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.MyUrlCallbackEntity;
import ai.botbrain.ttcloud.sdk.model.UrlCallbackEntity;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.InputMethodMemoryUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.MyJCVideoPlayerStandard;
import java.lang.ref.WeakReference;
import java.util.List;

public class TsdJieCaoVideoActivity
extends AppCompatActivity {
    private static final String TAG = TsdJieCaoVideoActivity.class.getSimpleName();
    private WebView mWebView;
    private View progress;
    private LinearLayout webViewContainer;
    private MyJCVideoPlayerStandard jcVideoPlayerStandard;
    private String webPageAddress;
    private String currentVideoAddress;
    private String title;
    private static final int RELOAD = 1000;
    private static final int OPEN_PLAYER = 1001;
    private static final int NOT_ALLOW_FAST_FORWARD = 1002;
    private static final int INJECT_JS = 1003;
    private final MyHandler mHandler = new MyHandler(this);
    private boolean isHasVideoUrl = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(0);
        this.setContentView(R.layout.tsd_activity_jie_cao_video);
        this.initData();
        this.initView();
        this.showloading();
        InsideWebViewClient mInsideWebViewClient = new InsideWebViewClient();
        this.mWebView.setWebChromeClient((WebChromeClient)new MyWebChromeClient());
        this.mWebView.setWebViewClient((WebViewClient)mInsideWebViewClient);
        this.mWebView.addJavascriptInterface((Object)this, "wpa");
        this.setWebSettings(this.mWebView);
        this.mWebView.loadUrl(this.webPageAddress);
        this.mHandler.sendEmptyMessageDelayed(1003, 5000L);
    }

    private void injectJs() {
        long startTime = System.currentTimeMillis();
        String js = JsPresenter.getInstance().getJsByWebAddress(this.webPageAddress);
        this.mWebView.loadUrl("javascript:" + js);
        long endTime = System.currentTimeMillis();
        LogUtil.i("Method(BotManager.onPageFinished) execution time\uff1a" + (endTime - startTime) + "ms");
    }

    private void showloading() {
        this.webViewContainer.setVisibility(0);
    }

    private void hideLoading() {
        this.progress.setVisibility(8);
        this.webViewContainer.setVisibility(4);
    }

    private void initData() {
        JCMediaManager.instance().releaseMediaPlayer();
        Intent intent = this.getIntent();
        this.webPageAddress = intent.getStringExtra("web_url");
        this.title = intent.getStringExtra("title");
        LogUtil.i(TAG, "web_url:" + this.webPageAddress);
    }

    private void initView() {
        this.mWebView = (WebView)this.findViewById(R.id.webview);
        this.progress = this.findViewById(R.id.progress_dialog);
        TextView txt_url = (TextView)this.findViewById(R.id.txt_url);
        ImageButton ib_back = (ImageButton)this.findViewById(R.id.ib_back);
        this.webViewContainer = (LinearLayout)this.findViewById(R.id.webViewContainer);
        this.jcVideoPlayerStandard = (MyJCVideoPlayerStandard)this.findViewById(R.id.videoplayer);
        this.jcVideoPlayerStandard.loadingProgressBar.setVisibility(0);
        this.jcVideoPlayerStandard.thumbImageView.setEnabled(false);
        this.jcVideoPlayerStandard.tinyBackImageView.setVisibility(4);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        ib_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TsdJieCaoVideoActivity.this.finish();
            }
        });
        txt_url.setText((CharSequence)this.webPageAddress);
    }

    private void setWebSettings(WebView mWebView) {
        WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setAppCachePath(Environment.getExternalStorageDirectory().getPath() + "databases/");
        webSettings.setAppCacheMaxSize(1061158912L);
        webSettings.setAppCacheEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAllowFileAccess(true);
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
        }
        webSettings.setDomStorageEnabled(true);
        webSettings.setUserAgentString("Mozilla/5.0 (iPad; CPU OS 6_0 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A5376e Safari/8536.25");
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    @JavascriptInterface
    public void execute(String json) {
        if (this.isFirstLaunch()) {
            this.mHandler.sendEmptyMessage(1000);
            return;
        }
        LogUtil.i(TAG, "json:" + json);
        if (JsPresenter.getInstance().isSHVideo(this.webPageAddress)) {
            this.currentVideoAddress = this.getSoHuUrl(json);
        } else {
            try {
                this.currentVideoAddress = this.getOtherVideoURL(json);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.currentVideoAddress = this.getSoHuUrl(json);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.currentVideoAddress)) {
            return;
        }
        this.mHandler.sendEmptyMessage(1001);
    }

    private void openPlayer() {
        if (this.isHasVideoUrl) {
            return;
        }
        this.isHasVideoUrl = true;
        LogUtil.i(TAG, "setUp(URL):" + this.currentVideoAddress);
        this.jcVideoPlayerStandard.setUp(this.currentVideoAddress, 2, new Object[]{this.title});
        this.jcVideoPlayerStandard.startButton.performClick();
        this.jcVideoPlayerStandard.backButton.setVisibility(0);
        if (JsPresenter.getInstance().isQYVideo(this.currentVideoAddress)) {
            this.mHandler.sendEmptyMessageDelayed(1002, 180000L);
        }
        this.jcVideoPlayerStandard.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TsdJieCaoVideoActivity.this.finish();
            }
        });
        this.hideLoading();
        this.jcVideoPlayerStandard.fullscreenButton.setVisibility(4);
    }

    private String getSoHuUrl(String json) {
        MyUrlCallbackEntity entity = GsonUtil.GsonToBean(json, MyUrlCallbackEntity.class);
        String url = entity.url;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.mHandler.sendEmptyMessage(1000);
        }
        return url;
    }

    private String getOtherVideoURL(String json) {
        UrlCallbackEntity entity = GsonUtil.GsonToBean(json, UrlCallbackEntity.class);
        UrlCallbackEntity.Video video = entity.video;
        List<UrlCallbackEntity.Sources> sources = video.sources;
        String url = sources.get((int)0).definitions.STANDARD_DEFINITION;
        LogUtil.i(TAG, "getVideoURL:" + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.mHandler.sendEmptyMessage(1000);
        }
        return url;
    }

    public void onBackPressed() {
        JCVideoPlayer.releaseAllVideos();
        super.onBackPressed();
    }

    protected void onPause() {
        super.onPause();
        try {
            JCMediaManager.instance().mediaPlayer.pause();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mWebView.pauseTimers();
        if (this.isFinishing()) {
            this.mWebView.loadUrl("about:blank");
            this.setContentView((View)new FrameLayout((Context)this));
        }
    }

    protected void onResume() {
        try {
            JCMediaManager.instance().mediaPlayer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onResume();
        this.mWebView.resumeTimers();
    }

    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        this.getWindow().setFlags(1024, 1024);
        this.setRequestedOrientation(0);
    }

    private boolean isFirstLaunch() {
        int lastVersion = (Integer)TsdSPUtils.get(this.getApplicationContext(), "pref_is_first_launcher", 0);
        int currentVersion = 0;
        try {
            PackageInfo info = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            currentVersion = info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        boolean isFirst = currentVersion > lastVersion;
        TsdSPUtils.put(this.getApplicationContext(), "pref_is_first_launcher", currentVersion);
        return isFirst;
    }

    protected void onDestroy() {
        super.onDestroy();
        InputMethodMemoryUtil.fixFocusedViewLeak(this.getApplication());
    }

    private class InsideWebViewClient
    extends WebViewClient {
        private InsideWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }
    }

    private class MyWebChromeClient
    extends WebChromeClient {
        private MyWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress == 100) {
                TsdJieCaoVideoActivity.this.injectJs();
                try {
                    TsdJieCaoVideoActivity.this.mHandler.sendEmptyMessageDelayed(1003, 1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<TsdJieCaoVideoActivity> mActivity;

        private MyHandler(TsdJieCaoVideoActivity activity) {
            this.mActivity = new WeakReference<TsdJieCaoVideoActivity>(activity);
        }

        public void handleMessage(Message msg) {
            TsdJieCaoVideoActivity activity = (TsdJieCaoVideoActivity)((Object)this.mActivity.get());
            if (activity != null) {
                switch (msg.what) {
                    case 1000: {
                        activity.mWebView.reload();
                        break;
                    }
                    case 1001: {
                        activity.openPlayer();
                        break;
                    }
                    case 1002: {
                        activity.jcVideoPlayerStandard.setNotAllowFastForward();
                        break;
                    }
                    case 1003: {
                        activity.injectJs();
                    }
                }
            }
        }
    }
}

