package ai.botbrain.ttcloud.sdk.util;

import android.content.Context;
import android.text.TextUtils;

import ai.botbrain.ttcloud.api.TtCloudListener;
import ai.botbrain.ttcloud.sdk.TsdConstant;

/**
 * Description：全局变量存储(声明周期之内的全局变量和生命周期之外的全局变量)
 * Creator: Created by peter.
 * Date: 17/5/4.
 */

public class TsdContextHolder {

    private static Context app;

    private static TtCloudListener mTtCloudListener;
    private static TtCloudListener.User mUser;
    private static boolean isShowActionBar = false;
    private static boolean isCanScroll = true;
    private static int font_size = 16;
    private static boolean hideComment = false;

    public static String getUserName() {
        return (String) TsdSPUtils.get(app, TsdConstant.PRE_USER_NAME, "");
    }

    private static void setUserName(String userName) {
        if (null == userName) return;
        TsdSPUtils.put(app, TsdConstant.PRE_USER_NAME, userName);
    }

    public static String getUserNickName() {
        return (String) TsdSPUtils.get(app, TsdConstant.PRE_USER_NICK_NAME, "");
    }

    private static void setUserNickName(String userNickName) {
        if (null == userNickName) return;
        TsdSPUtils.put(app, TsdConstant.PRE_USER_NICK_NAME, userNickName);
    }

    public static String getUserId() {
        return (String) TsdSPUtils.get(app, TsdConstant.PRE_USER_ID, "");
    }

    public static void setUserId(String userId) {
        if (null == userId) return;
        TsdSPUtils.put(app, TsdConstant.PRE_USER_ID, userId);
    }

    public static String getUserAvatar() {
        return (String) TsdSPUtils.get(app, TsdConstant.PRE_USER_AVATAR, "");
    }

    private static void setUserAvatar(String userAvatar) {
        if (null == userAvatar) return;
        TsdSPUtils.put(app, TsdConstant.PRE_USER_AVATAR, userAvatar);
    }

    public static void initalUser(TtCloudListener.User user) {
        mUser = user;
        String userId = mUser.getUserId();
        setUserId(userId);

        String userName = mUser.getUserName();
        setUserName(userName);

        String userNickName = mUser.getUserNickName();
        setUserNickName(userNickName);

        String userAvatar = mUser.getUserAvatar();
        setUserAvatar(userAvatar);
    }

    public static TtCloudListener.User getUser() {
        return mUser;
    }

    public static void initialContext(Context context) {
        app = context;
    }

    public static void initTtCloudListener(TtCloudListener ttCloudListener) {
        mTtCloudListener = ttCloudListener;
    }

    public static Context getContext() {
        return app;
    }

    public static TtCloudListener getTtCloudListener() {
        return mTtCloudListener;
    }

    public static boolean isLogin() {
        String userId = (String) TsdSPUtils.get(app, TsdConstant.PRE_USER_ID, "");
        return !TextUtils.isEmpty(userId);
    }

    public static boolean isShowActionBar() {
        return isShowActionBar;
    }

    public static void setIsShowActionBar(boolean isShowActionBar) {
        TsdContextHolder.isShowActionBar = isShowActionBar;
    }

    public static void setCanScroll(boolean b) {
        isCanScroll = b;
    }

    public static boolean isCanScroll() {
        return isCanScroll;
    }

    public static void clearUser() {
        mUser = null;
    }

    private static int loadErrorViewRes;

    public static void showLoadErrorView(int imageRes) {
        loadErrorViewRes = imageRes;
    }

    public static int getLoadingErrorView() {
        return loadErrorViewRes;
    }

    public static int getFont_size() {
        return font_size;
    }

    public static void setFont_size(int font_size) {
        TsdContextHolder.font_size = font_size;
    }

    public static void setHideComment() {
        hideComment = true;
    }

    public static boolean getHideComment() {
        return hideComment;
    }
}
