package ai.botbrain.ttcloud.sdk.presenter;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;

import com.google.gson.Gson;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

import ai.botbrain.ttcloud.sdk.util.LogUtil;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class AppsListPresenter {

    private static final String TAG = AppsListPresenter.class.getSimpleName();

    private final Context mContext;
    private Gson gson;
    private SPUtils spUtils;
    private MD5 md5;
    private static AppsListPresenter MY_INSTANCE = null;

    private List<String> temp_appNames;
    private ArrayList<AppInfo> temp_appInfos;

    private static final int MSG_SUCCESS = 001;
    private static final String SP_APP_LIST = "app_list";
    private static final String BASE_URL = "https://log.firedata.cc/log/v2/FDU5D2P34/app_list?data=";

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_SUCCESS:
                    sendMessageHttp();
                    break;
            }
        }
    };

    private AppsListPresenter(final Context context) {
        mContext = context;
        init();
    }

    public static void upload(final Context context) {
        if (MY_INSTANCE == null) {
            synchronized (AppsListPresenter.class) {
                if (MY_INSTANCE == null) {
                    MY_INSTANCE = new AppsListPresenter(context);
                }
            }
        }
    }

    private void init() {
        spUtils = new SPUtils();
        temp_appNames = new ArrayList<>();
        md5 = new MD5();
        gson = new Gson();
        Thread mThread = new Thread(runnable);
        mThread.start();
    }

    private Runnable runnable = new Runnable() {

        @Override
        public void run() {
            temp_appInfos = getInstallApkInfo();
            if (isChanged()) {
                mHandler.sendEmptyMessage(MSG_SUCCESS);
                LogUtil.i(TAG, "变动了");
            } else {
                LogUtil.i(TAG, "没有变化");
            }
        }
    };

    private void saveData() {
        String str = gson.toJson(temp_appNames);
        String enToStr = null;
        try {
            enToStr = md5.getMD5(str);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        spUtils.put(mContext, SP_APP_LIST, enToStr);
    }

    private boolean isChanged() {
        String json_apps = (String) spUtils.get(mContext, SP_APP_LIST, "");
        String str = null;
        try {
            str = md5.getMD5(gson.toJson(temp_appNames));
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }

        if (null != str && str.equals(json_apps)) {
            return false;
        } else {
            return true;
        }
    }

    public ArrayList<AppInfo> getInstallApkInfo() {
        long startTime = System.currentTimeMillis();
        temp_appNames = new ArrayList<>();
        temp_appInfos = new ArrayList<AppInfo>();
        AppInfo appInfo;
        PackageManager pm = mContext.getPackageManager();
        List<PackageInfo> list = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : list) {
            appInfo = new AppInfo();
            appInfo.name = packageInfo.applicationInfo.loadLabel(pm).toString();
            appInfo.pakg = packageInfo.applicationInfo.packageName;
            appInfo.ftime = String.valueOf(packageInfo.firstInstallTime);
            appInfo.ver = packageInfo.versionName;
            appInfo.proc = packageInfo.applicationInfo.processName;

            if ((packageInfo.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) == 0) {
                appInfo.type = "1";
                LogUtil.i(TAG, "非系统应用" + appInfo.name);
                temp_appNames.add(appInfo.pakg + appInfo.ver);
                temp_appInfos.add(appInfo);
            } else {
                LogUtil.i(TAG, "系统应用：" + appInfo.name);
                appInfo.type = "0";
            }
        }

        long endTime = System.currentTimeMillis();
        LogUtil.i(TAG, "time： " + (endTime - startTime) + "ms");
        return temp_appInfos;
    }

    private String generateJson(String sdk_ver, String time, String imei, String mac, String apps) {
        try {
            apps = URLEncoder.encode(apps, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        String str = "sdk_ver=" + sdk_ver + "&" +
                "time=" + time + "&" +
                "imei=" + imei + "&" +
                "mac=" + mac + "&" +
                "apps=" + apps;
        LogUtil.i(TAG, str);
        return Base64.encodeToString(str.trim().getBytes(), Base64.NO_WRAP);
    }

    private String getHttpUrl() {
        DeviceUtils du = new DeviceUtils();
        Data mData = new Data();
        mData.imei = du.getIMEI(mContext);
        mData.time = String.valueOf(System.currentTimeMillis());
        mData.apps = temp_appInfos;
        mData.mac = du.getMacAddress(mContext);

        String str_apps = gson.toJson(mData.apps);
        LogUtil.i(TAG, "" + str_apps);
        String httpUrl = BASE_URL + generateJson(du.getVersion(mContext),
                mData.time, mData.imei, mData.mac, str_apps);
        return httpUrl;
    }

    private void sendMessageHttp() {
        String url = getHttpUrl();
        /*
        OkHttpUtils
                .get()
                .url(url)
                .build()
                .execute(new StringCallback() {
                    @Override
                    public void onError(Call call, Exception e, int i) {
                        LogUtil.i(TAG, "error");
                    }

                    @Override
                    public void onResponse(String response, int i) {
                        saveData();
                        //Toast.makeText(mContext, "应用列表有变动，已通知服务器", Toast.LENGTH_LONG).show();
                        //LogUtil.i(TAG, "应用列表有变动，已通知服务器");
                    }
                });
                */
    }

    class Data {

        public String imei;

        public String time;

        public String mac;

        public String sdk_ver;

        public List<AppInfo> apps;
    }

    class DeviceUtils {

        public String getMacAddress(Context context) {
            String macAddress = null;
            try {
                String wifiInterfaceName = "wlan0";
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iF = interfaces.nextElement();
                    if (iF.getName().equalsIgnoreCase(wifiInterfaceName)) {
                        byte[] addr = iF.getHardwareAddress();
                        if (addr == null || addr.length == 0) {
                            return null;
                        }

                        StringBuilder buf = new StringBuilder();
                        for (byte b : addr) {
                            buf.append(String.format("%02X:", b));
                        }
                        if (buf.length() > 0) {
                            buf.deleteCharAt(buf.length() - 1);
                        }
                        macAddress = buf.toString();
                        break;
                    }
                }
            } catch (SocketException se) {
                macAddress = null;
            }

            if (TextUtils.isEmpty(macAddress)) {
                android.net.wifi.WifiManager wifi = (android.net.wifi.WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
                macAddress = wifi.getConnectionInfo().getMacAddress();
            }

            return macAddress;
        }

        public String getIMEI(Context context) {
            String deviceId = "";
            /*if (ContextCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                if (ContextCompat.checkSelfPermission(context, Manifest.permission.ACCESS_WIFI_STATE) == PackageManager.PERMISSION_GRANTED) {
                    TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                    deviceId = tm.getDeviceId();
                }
            }*/

            return deviceId;
        }

        public String getVersion(Context context) {
            try {
                PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                return pi.versionName;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                return "unknow";
            }
        }
    }

    class AppInfo implements Serializable {

        public String name;
        public String pakg;
        public String proc;
        public String ftime;
        public String ver;
        public String type;
    }

    class SPUtils {

        private SharedPreferencesCompat sfc = new SharedPreferencesCompat();

        public final String FILE_NAME = "app_list";

        public SPUtils() {
        }

        public void put(Context context, String key, Object object) {

            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = sp.edit();
            if (object instanceof String) {
                editor.putString(key, (String) object);
            } else if (object instanceof Integer) {
                editor.putInt(key, (Integer) object);
            } else if (object instanceof Boolean) {
                editor.putBoolean(key, (Boolean) object);
            } else if (object instanceof Float) {
                editor.putFloat(key, (Float) object);
            } else if (object instanceof Long) {
                editor.putLong(key, (Long) object);
            } else {
                editor.putString(key, object.toString());
            }

            sfc.apply(editor);
        }

        public Object get(Context context, String key, Object defaultObject) {
            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);

            if (defaultObject instanceof String) {
                return sp.getString(key, (String) defaultObject);
            } else if (defaultObject instanceof Integer) {
                return sp.getInt(key, (Integer) defaultObject);
            } else if (defaultObject instanceof Boolean) {
                return sp.getBoolean(key, (Boolean) defaultObject);
            } else if (defaultObject instanceof Float) {
                return sp.getFloat(key, (Float) defaultObject);
            } else if (defaultObject instanceof Long) {
                return sp.getLong(key, (Long) defaultObject);
            }

            return null;
        }

        public void remove(Context context, String key) {
            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = sp.edit();
            editor.remove(key);
            sfc.apply(editor);
        }

        public void clear(Context context) {
            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = sp.edit();
            editor.clear();
            sfc.apply(editor);
        }

        public boolean contains(Context context, String key) {
            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
            return sp.contains(key);
        }

        public Map<String, ?> getAll(Context context) {
            SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
            return sp.getAll();
        }

    }

    class SharedPreferencesCompat {
        private final Method sApplyMethod = findApplyMethod();

        @SuppressWarnings({"unchecked", "rawtypes"})
        private Method findApplyMethod() {
            try {
                Class clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply");
            } catch (NoSuchMethodException e) {
            }
            return null;
        }

        public void apply(SharedPreferences.Editor editor) {
            try {
                if (sApplyMethod != null) {
                    sApplyMethod.invoke(editor);
                    return;
                }
            } catch (IllegalArgumentException e) {
            } catch (IllegalAccessException e) {
            } catch (InvocationTargetException e) {
            }
            editor.commit();
        }
    }

    private class MD5 {
        private String getMD5(String val) throws NoSuchAlgorithmException {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(val.getBytes());
            byte[] m = md5.digest();
            return getString(m);
        }

        private String getString(byte[] b) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < b.length; i++) {
                sb.append(b[i]);
            }
            return sb.toString();
        }
    }
}
