package ai.botbrain.ttcloud.sdk.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.adapter.MyFragmentPagerAdapter;
import ai.botbrain.ttcloud.sdk.colorUi.util.ColorUiUtil;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.ClickCategoryEvent;
import ai.botbrain.ttcloud.sdk.model.ThemeEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AppsListPresenter;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.MyViewPager;
import ai.botbrain.ttcloud.sdk.widget.TsdTabLayout;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class IndexFragment extends Fragment implements LoadingView.OnRetryListener, MyFragmentPagerAdapter.MyFragmentPagerAdapterCallBack, TsdTabLayout.RenderListener {

    private RestApi restApi;

    private int tab_position = 0;
    private String currentSubColumnsId;
    private List<String> label_idList;

    private View rootView;
    private MyViewPager mViewPager;
    private TsdTabLayout mTabLayout;
    public LoadingView mLoadingView;

    private boolean isInitTop;
    private MyFragmentPagerAdapter adapter;

    public static final String ARG_FEED_TYPE = "arg_type_video";

    public static final String TYPE_ARTICLE = "article";
    public static final String TYPE_VIDEO = "video";

    private Fragment mCurrentFragment;

    public static IndexFragment newInstance(final String type) {
        IndexFragment fragment = new IndexFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_FEED_TYPE, type);
        fragment.setArguments(bundle);
        return fragment;
    }

    @SuppressWarnings("unused")
    public static IndexFragment newInstance() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), ARG_FEED_TYPE);
        return newInstance(null);
    }

    public IndexFragment() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), ARG_FEED_TYPE);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (rootView == null) {
            setMyTheme();
            rootView = inflater.inflate(R.layout.tsd_fragment_index, container, false);
            initView(rootView);
        }
        ViewGroup parent = (ViewGroup) rootView.getParent();
        if (parent != null) {
            parent.removeView(rootView);
        }
        return rootView;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            String arg_type = getArguments().getString(ARG_FEED_TYPE);
            TsdSPUtils.put(TsdContextHolder.getContext(), TsdConstant.FEED_TYPE, arg_type);
        }
        mLoadingView = new LoadingView(TsdContextHolder.getContext());
        restApi = new RestApiImpl();
        AppsListPresenter.upload(TsdContextHolder.getContext());
        initJsHttp();
        initData();
    }

    private void setMyTheme() {
        int i = TtCloudManager.getCurrentTheme();
        if (i == 0) {
            getActivity().setTheme(R.style.tsd_theme_default);
        } else if (i == 1) {
            getActivity().setTheme(R.style.tsd_theme_night);
        }
    }

    private void initData() {
        label_idList = new ArrayList<>();
    }

    public void setAppNameListener(AppNameListener listener) {
        appNameListener = listener;
    }

    public AppNameListener appNameListener;

    @Override
    public void getCurrentFragment(Fragment fragment) {
        mCurrentFragment = fragment;
    }

    @Override
    public void renderTabLayoutFail() {
        mLoadingView.notifyDataChanged(LoadingView.State.error);
    }

    private TopTitleEntity.Data mData;

    @Override
    public void renderTabLayoutSuccess(TopTitleEntity.Data data, String appName) {
        mData = data;
        mLoadingView.notifyDataChanged(LoadingView.State.done);
        if (!isInitTop) {
            adapter = new MyFragmentPagerAdapter(getChildFragmentManager(), data);
            adapter.setCallBack(this);
            mViewPager.setAdapter(adapter);
            isInitTop = true;
        } else {
            adapter.notifyDataSetChanged();
        }

        if (appNameListener != null)
            appNameListener.appName(appName);

        mTabLayout.setupWithViewPager(mViewPager);

        initSecondaryDirectoryStatus(data);
    }

    public interface AppNameListener {
        void appName(String appName);
    }

    @Override
    public void onRetry() {
        mTabLayout.retryRender();
    }

    private void initView(View view) {
        RelativeLayout rl_title = (RelativeLayout) view.findViewById(R.id.rl_title);
        mLoadingView = (LoadingView) view.findViewById(R.id.loading_view);
        mLoadingView.setOnRetryListener(this);
        mViewPager = (MyViewPager) view.findViewById(R.id.bot_news_pager);
        mTabLayout = (TsdTabLayout) view.findViewById(R.id.tsd_tablayout);
        mTabLayout.setCallBack(this);
        if (TsdContextHolder.isShowActionBar()) {
            rl_title.setVisibility(View.GONE);
        }
        mViewPager.setOffscreenPageLimit(10);
    }

    private void initSecondaryDirectoryStatus(TopTitleEntity.Data d) {
        //List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        List<TopTitleEntity.Columns> datas = d.columns;
        if (null == datas || datas.size() <= 0) return;
        for (TopTitleEntity.Columns labelData : datas) {
            List<TopTitleEntity.SubColumns> labelDatas = labelData.subColumns;
            if (null != labelDatas && labelDatas.size() > 0) {
                TopTitleEntity.SubColumns data = labelDatas.get(0);
                data.isSelected = true;
            }
        }
    }

    private void initJsHttp() {
        new Thread() {
            @Override
            public void run() {
                super.run();
                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
            }
        }.start();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEvent(String event) {
        try {
            String[] ss = event.split("://");
            String a = ss[1].split("/")[0];
            for (int i = 0; i < label_idList.size(); i++) {
                String label_id = label_idList.get(i);
                if (a.equals(label_id)) {
                    mViewPager.setCurrentItem(i);
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSubColumnsIdBy(int tab_position, int subColumns_position) {
        if (null == mData || null == mData.columns) {
            return;
        }
        try {
            TopTitleEntity.Columns columns = mData.columns.get(tab_position);
            if (null == columns.subColumns || columns.subColumns.size() <= 0)
                return;

            currentSubColumnsId = columns.subColumns.get(subColumns_position).id;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(ClickCategoryEvent event) {
        int position = event.position;
        getSubColumnsIdBy(tab_position, position);
        if (null != mCurrentFragment && mCurrentFragment instanceof RecommendHomeFragment)
            ((RecommendHomeFragment) mCurrentFragment).refresh(position);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(BuriedPointEvent event) {

        if (null == mData || null == mData.columns) {
            return;
        }

        String columns_id = mData.columns.get(tab_position).id;

        String iid = event.getIid();
        Object alg = event.getAlg();
        String action = event.getAction();
        String num = event.getNum();
        currentSubColumnsId = null == currentSubColumnsId ? "" : currentSubColumnsId;
        restApi.commentToService(iid, alg, action, columns_id + "_" + currentSubColumnsId, num, null);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(ThemeEvent event) {
        int theme = event.theme;
        View rootView = getActivity().getWindow().getDecorView();
        if (theme == 1) {
            getActivity().setTheme(R.style.tsd_theme_night);
            mTabLayout.setNightTheme();
        } else {
            mTabLayout.setDayTheme();
            getActivity().setTheme(R.style.tsd_theme_default);
        }
        ColorUiUtil.changeTheme(rootView, getActivity().getTheme());
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onResume() {
        super.onResume();
        mTabLayout.onResume();
    }

}
