package ai.botbrain.ttcloud.sdk.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TvAdapter1 extends BaseAdapter {

    private Context mContext;
    private RecommendEntity.Datas mData;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public TvAdapter1(Context context, RecommendEntity.Datas data) {
        this.mContext = context;
        this.mData = data;
    }

    @Override
    public int getCount() {
        List<RecommendEntity.TvUrls> tv_urls = mData.tv_urls;
        return null == tv_urls ? 0 : tv_urls.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        final ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate(mContext, R.layout.tsd_item_tv, null);
            viewHolder.btnNum = (Button) convertView.findViewById(R.id.btn_num);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        final String channel = null == mData.channel ? "" : mData.channel;
        final String iid = null == mData.iid ? "" : mData.iid;
        final Object alg = null == mData.alg ? "" : mData.alg;

        final List<RecommendEntity.TvUrls> tv_urls = mData.tv_urls;
        final RecommendEntity.TvUrls entity = tv_urls.get(position);
        final String num;
        if (!channel.equals("综艺")) {
            num = entity.episode;
        } else {
            String text = entity.episode;
            String str1 = text.substring(0, 4);
            String str2 = text.substring(4, 6);
            String str3 = text.substring(6, 8);
            num = str1 + "-" + str2 + "-" + str3;
        }
        final boolean is_free = entity.sources.get(0).is_free;

        viewHolder.btnNum.setText(num);
        if (is_free) {
            viewHolder.btnNum.setTextColor(mContext.getResources().getColor(R.color.tsd_black));
        } else {
            viewHolder.btnNum.setTextColor(mContext.getResources().getColor(R.color.tsd_gray));
        }

        viewHolder.btnNum.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                FireDataManager.clickCsn(channel, channel, iid, num);

                if (is_free) {
                    final String url = tv_urls.get(position).sources.get(0).url;
                    EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_CLICK, iid, alg, null, num));
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread() {
                            @Override
                            public void run() {
                                super.run();
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                mainHandler.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        FireDataManager.play(mData.channel);
                                        JsPresenter.getInstance().StartPlayback(mContext, url, channel, iid);
                                    }
                                });
                            }
                        }.start();
                    } else {
                        FireDataManager.play(mData.channel);
                        JsPresenter.getInstance().StartPlayback(mContext, url, channel, iid);
                    }
                }
            }
        });
        return convertView;
    }

    private static class ViewHolder {
        private Button btnNum;
    }

}
