package ai.botbrain.ttcloud.sdk.activity;

import android.app.Activity;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;

import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.RecommendHomeAdapter;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AdManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TsdSearchActivity extends Activity implements BGARefreshLayout.BGARefreshLayoutDelegate {

    private SearchObserver searchObserver;
    private RecommendHomeAdapter recommendHomeAdapter;

    private boolean PULL_TO_REFRESH = true;
    private int pageCurrent = 0;
    private String searchString;
    private List<RecommendEntity.Data> datas;

    private ImageView iv_clear_img;
    private EditText et_chat_title_search;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_bbn_activity_search);
        datas = new ArrayList<>();
        recommendHomeAdapter = new RecommendHomeAdapter(this, datas, null);
        searchObserver = new SearchObserver();
        Firedata.pageViewStart("SearchActivity");
        initView();
    }

    BGARefreshLayout mRefreshLayout;

    private void initRefreshLayout() {
        mRefreshLayout = (BGARefreshLayout) findViewById(R.id.rl_modulename_refresh);
        mRefreshLayout.setDelegate(this);
        mRefreshLayout.setPullDownRefreshEnable(false);
        mRefreshLayout.setRefreshScaleDelegate(new BGARefreshLayout.BGARefreshScaleDelegate() {
            @Override
            public void onRefreshScaleChanged(float scale, int moveYDistance) {
            }
        });
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(TsdSearchActivity.this, true);

        refreshViewHolder.setPullDownRefreshText("下拉推荐");
        refreshViewHolder.setRefreshingText("努力推荐中");
        refreshViewHolder.setReleaseRefreshText("释放推荐");
        refreshViewHolder.setLoadingMoreText("努力推荐中");

        mRefreshLayout.setRefreshViewHolder(refreshViewHolder);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Firedata.pageViewEnd("SearchActivity");
    }

    public void backClick(View view) {
        finish();
    }

    private void initView() {
        initRefreshLayout();
        iv_clear_img = (ImageView) findViewById(R.id.bbn_iv_clear_img);
        et_chat_title_search = (EditText) findViewById(R.id.et_chat_title_search);
        et_chat_title_search.addTextChangedListener(mTextWatcher);
        iv_clear_img.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                et_chat_title_search.setText("");
            }
        });

        et_chat_title_search.setOnEditorActionListener(new OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                boolean handled = false;
                if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                    handled = true;
                    KeyBoardUtil.hide(TsdSearchActivity.this);
                    pageCurrent = 0;
                    PULL_TO_REFRESH = true;
                    RestApiImpl.searchVideo(searchObserver, searchString, String.valueOf(pageCurrent));
                }
                return handled;
            }
        });

        findViewById(R.id.ib_search).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {
                KeyBoardUtil.hide(TsdSearchActivity.this);
                pageCurrent = 0;
                PULL_TO_REFRESH = true;
                RestApiImpl.searchVideo(searchObserver, searchString, String.valueOf(pageCurrent));
            }
        });
        ListView mListView = (ListView) findViewById(R.id.load_more_small_image_list_view);
        mListView.setAdapter(recommendHomeAdapter);
    }

    private TextWatcher mTextWatcher = new TextWatcher() {
        public void afterTextChanged(Editable s) {
            searchString = et_chat_title_search.getText().toString();
            if (!TextUtils.isEmpty(searchString) && searchString.length() > 0) {
                iv_clear_img.setVisibility(View.VISIBLE);
            } else {
                iv_clear_img.setVisibility(View.GONE);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

    };

    public synchronized void renderFeedList(boolean PULL_TO_REFRESH, String response) {
        RecommendEntity recommendEntity;
        mRefreshLayout.endLoadingMore();
        try {
            response = response.equals("") ? "error" : response;
            recommendEntity = GsonUtil.GsonToBean(response, RecommendEntity.class);
            if (PULL_TO_REFRESH) {
                datas.clear();
            }

            datas.addAll(recommendEntity.data);
            AdManager.init(datas);
            final SparseArray<String> count = AdManager.getAdSlots();
            //recommendHomeAdapter.loadAD(count);
            recommendHomeAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {

    }

    @Override
    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        PULL_TO_REFRESH = false;
        pageCurrent = pageCurrent + 10;
        RestApiImpl.searchVideo(searchObserver, searchString, String.valueOf(pageCurrent));
        return true;
    }

    private final class SearchObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            mRefreshLayout.endLoadingMore();
        }

        @Override
        public void onSuccess(Response<String> response) {
            String s = response.body();
            renderFeedList(PULL_TO_REFRESH, s);
        }
    }
}
