package ai.botbrain.ttcloud.sdk.activity;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.lang.ref.WeakReference;
import java.util.List;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.MyUrlCallbackEntity;
import ai.botbrain.ttcloud.sdk.model.UrlCallbackEntity;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.InputMethodMemoryUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import fm.jiecao.jcvideoplayer_lib.JCMediaManager;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayer;
import fm.jiecao.jcvideoplayer_lib.JCVideoPlayerStandard;
import fm.jiecao.jcvideoplayer_lib.MyJCVideoPlayerStandard;

import static ai.botbrain.ttcloud.sdk.util.JS_Collection.AGENT;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TsdJieCaoVideoActivity extends AppCompatActivity {
    private static final String TAG = TsdJieCaoVideoActivity.class.getSimpleName();

    private WebView mWebView;
    private View progress;
    private LinearLayout webViewContainer;
    private MyJCVideoPlayerStandard jcVideoPlayerStandard;

    private String webPageAddress;
    private String currentVideoAddress;
    private String title;

    private static final int RELOAD = 1000;
    private static final int OPEN_PLAYER = RELOAD + 1;
    private static final int NOT_ALLOW_FAST_FORWARD = OPEN_PLAYER + 1;
    private static final int INJECT_JS = NOT_ALLOW_FAST_FORWARD + 1;

    private final MyHandler mHandler = new MyHandler(this);

    private static class MyHandler extends Handler {
        private final WeakReference<TsdJieCaoVideoActivity> mActivity;

        private MyHandler(TsdJieCaoVideoActivity activity) {
            mActivity = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            TsdJieCaoVideoActivity activity = mActivity.get();
            if (activity != null) {
                switch (msg.what) {
                    case RELOAD:
                        activity.mWebView.reload();
                        break;
                    case OPEN_PLAYER:
                        activity.openPlayer();
                        break;
                    case NOT_ALLOW_FAST_FORWARD:
                        activity.jcVideoPlayerStandard.setNotAllowFastForward();
                        break;
                    case INJECT_JS:
                        activity.injectJs();
                        break;
                }
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        setContentView(R.layout.tsd_activity_jie_cao_video);
        initData();
        initView();
        showloading();

        InsideWebViewClient mInsideWebViewClient = new InsideWebViewClient();
        mWebView.setWebChromeClient(new MyWebChromeClient());
        mWebView.setWebViewClient(mInsideWebViewClient);
        mWebView.addJavascriptInterface(TsdJieCaoVideoActivity.this, "wpa");
        setWebSettings(mWebView);
        mWebView.loadUrl(webPageAddress);
        mHandler.sendEmptyMessageDelayed(INJECT_JS, 1000 * 5);
    }

    private class MyWebChromeClient extends WebChromeClient {
        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress == 100) {
                injectJs();
                try {
                    mHandler.sendEmptyMessageDelayed(INJECT_JS, 1000 * 1);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void injectJs() {
        long startTime = System.currentTimeMillis();
        String js = JsPresenter.getInstance().getJsByWebAddress(webPageAddress);
        mWebView.loadUrl("javascript:" + js);
        long endTime = System.currentTimeMillis();
        LogUtil.i("Method(BotManager.onPageFinished) execution time：" + (endTime - startTime) + "ms");
    }

    private void showloading() {
        webViewContainer.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        progress.setVisibility(View.GONE);
        webViewContainer.setVisibility(View.INVISIBLE);
    }

    private void initData() {
        JCMediaManager.instance().releaseMediaPlayer();
        Intent intent = getIntent();
        webPageAddress = intent.getStringExtra("web_url");
        title = intent.getStringExtra("title");

        LogUtil.i(TAG, "web_url:" + webPageAddress);
    }

    private void initView() {
        mWebView = (WebView) findViewById(R.id.webview);
        progress = findViewById(R.id.progress_dialog);
        TextView txt_url = (TextView) findViewById(R.id.txt_url);
        ImageButton ib_back = (ImageButton) findViewById(R.id.ib_back);
        webViewContainer = (LinearLayout) findViewById(R.id.webViewContainer);
        jcVideoPlayerStandard = (MyJCVideoPlayerStandard) findViewById(R.id.videoplayer);
        jcVideoPlayerStandard.loadingProgressBar.setVisibility(View.VISIBLE);
        jcVideoPlayerStandard.thumbImageView.setEnabled(false);
        jcVideoPlayerStandard.tinyBackImageView.setVisibility(View.INVISIBLE);

        mWebView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });

        ib_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        txt_url.setText(webPageAddress);
    }

    private void setWebSettings(WebView mWebView) {
        WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        webSettings.setAppCachePath(Environment.getExternalStorageDirectory().getPath() + "databases/");
        webSettings.setAppCacheMaxSize(1012 * 1024 * 1024);
        webSettings.setAppCacheEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAllowFileAccess(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
        }
        webSettings.setDomStorageEnabled(true);
        webSettings.setUserAgentString(AGENT);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            WebView.setWebContentsDebuggingEnabled(true);
        }
    }

    private boolean isHasVideoUrl = false;

    @JavascriptInterface
    public void execute(String json) {
        if (isFirstLaunch()) {
            mHandler.sendEmptyMessage(RELOAD);
            return;
        }
        LogUtil.i(TAG, "json:" + json);
        if (JsPresenter.getInstance().isSHVideo(webPageAddress)) {
            currentVideoAddress = getSoHuUrl(json);
        } else {
            try {
                currentVideoAddress = getOtherVideoURL(json);
            } catch (Exception e) {
                e.printStackTrace();
                currentVideoAddress = getSoHuUrl(json);
            }
        }

        if (TextUtils.isEmpty(currentVideoAddress))
            return;
        mHandler.sendEmptyMessage(OPEN_PLAYER);
    }

    private void openPlayer() {
        if (isHasVideoUrl)
            return;
        isHasVideoUrl = true;
        LogUtil.i(TAG, "setUp(URL):" + currentVideoAddress);
        jcVideoPlayerStandard.setUp(currentVideoAddress, JCVideoPlayerStandard.SCREEN_WINDOW_FULLSCREEN, title);
        jcVideoPlayerStandard.startButton.performClick();
        jcVideoPlayerStandard.backButton.setVisibility(View.VISIBLE);

        if (JsPresenter.getInstance().isQYVideo(currentVideoAddress)) {
            mHandler.sendEmptyMessageDelayed(NOT_ALLOW_FAST_FORWARD, 1000 * 60 * 3);
        }

        jcVideoPlayerStandard.backButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        hideLoading();

        jcVideoPlayerStandard.fullscreenButton.setVisibility(View.INVISIBLE);
    }

    private String getSoHuUrl(String json) {
        MyUrlCallbackEntity entity = GsonUtil.GsonToBean(json, MyUrlCallbackEntity.class);
        String url = entity.url;
        if (TextUtils.isEmpty(url)) {
            mHandler.sendEmptyMessage(RELOAD);
        }
        return url;
    }

    private String getOtherVideoURL(String json) {
        UrlCallbackEntity entity = GsonUtil.GsonToBean(json, UrlCallbackEntity.class);
        UrlCallbackEntity.Video video = entity.video;
        List<UrlCallbackEntity.Sources> sources = video.sources;
        String url = sources.get(0).definitions.STANDARD_DEFINITION;
        LogUtil.i(TAG, "getVideoURL:" + url);
        if (TextUtils.isEmpty(url)) {
            mHandler.sendEmptyMessage(RELOAD);
        }
        return url;
    }

    private class InsideWebViewClient extends WebViewClient {

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }

    }

    @Override
    public void onBackPressed() {
        JCVideoPlayer.releaseAllVideos();
        super.onBackPressed();
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            JCMediaManager.instance().mediaPlayer.pause();
        } catch (Exception e) {
            e.printStackTrace();
        }
        mWebView.pauseTimers();
        if (isFinishing()) {
            mWebView.loadUrl("about:blank");
            setContentView(new FrameLayout(this));
        }
    }

    @Override
    protected void onResume() {
        try {
            JCMediaManager.instance().mediaPlayer.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onResume();
        mWebView.resumeTimers();
    }

    @Override
    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
    }

    private boolean isFirstLaunch() {
        boolean isFirst;
        int lastVersion = (int) TsdSPUtils.get(getApplicationContext(), TsdConstant.PREF_IS_FIRST_LAUNCH, 0);
        int currentVersion = 0;
        try {
            PackageInfo info = getPackageManager().getPackageInfo(getPackageName(), 0);
            currentVersion = info.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (currentVersion > lastVersion) {
            isFirst = true;
        } else {
            isFirst = false;
        }
        TsdSPUtils.put(getApplicationContext(), TsdConstant.PREF_IS_FIRST_LAUNCH, currentVersion);
        return isFirst;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        InputMethodMemoryUtil.fixFocusedViewLeak(getApplication());
    }
}
