package ai.botbrain.ttcloud.api;


import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import org.greenrobot.eventbus.EventBus;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdSearchActivity;
import ai.botbrain.ttcloud.sdk.fragment.IndexFragment;
import ai.botbrain.ttcloud.sdk.model.ThemeEvent;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.Ad360Mamager;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.OkHttpManager;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TtCloudManager {

    public static boolean DEBUG = false;
    private static boolean mShowResponse = false;
    public static boolean LOG = true;
    private static String appId;

    private static String sid = "";

    public static void init(Application app, TtcClient client) {
        try {
            ApplicationInfo appInfo = app.getPackageManager()
                    .getApplicationInfo(app.getPackageName(), PackageManager.GET_META_DATA);
            appId = appInfo.metaData.getString("TTC_APPID");
            if (TextUtils.isEmpty(appId))
                throw new IllegalArgumentException("--请在配置清单文件中添加 TTC_APPID-----");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        if (null != client) {
            LOG = client.isShowLog();
            mShowResponse = client.isShowResponse();
            DEBUG = client.isDebug();
        }
        hideComment(client);
        TsdContextHolder.initialContext(app);
        OkHttpManager.initOkGo(app, mShowResponse);
        Ad360Mamager.initSdk(false);
        sid = TimeUtil.getTimestamp();
        new RestApiImpl().getYouKuConfig();
        FireDataManager.init(app, appId, "");
    }

    private static void hideComment(TtcClient client) {
        if (null != client && client.isHideComment()) {
            TsdContextHolder.setHideComment();
        }
    }

    public static void init(Application application) {
        init(application, null);
    }

    @SuppressWarnings("unused")
    public static void hideActionBar(boolean b) {
        TsdContextHolder.setIsShowActionBar(b);
    }

    public static String getAppId() {
        return appId;
    }

    public static String getSid() {
        return sid;
    }

    public static void setCallBack(TtCloudListener ttCloudListener) {
        TsdContextHolder.initTtCloudListener(ttCloudListener);
    }

    public static void login(TtCloudListener.User user) {
        TsdContextHolder.initalUser(user);
    }

    /**
     * 注销操作
     */
    public static void logout() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), TsdConstant.PRE_USER_ID);
        TsdContextHolder.clearUser();
    }

    public static boolean isLogin() {
        return TsdContextHolder.isLogin();
    }

    /**
     * 禁止viewPager滑动
     */
    @SuppressWarnings("unused")
    public static void setNotScroll() {
        TsdContextHolder.setCanScroll(false);
    }

    @SuppressWarnings("unused")
    public static void setLoadingErrorView(int loadingErrorView) {
        TsdContextHolder.showLoadErrorView(loadingErrorView);
    }

    protected static void setFontSize(int size) {
        TsdContextHolder.setFont_size(size);
    }

    @SuppressWarnings("unused")
    public static void openArticleDetailActivity(Context context, String extra_iid) {
        Intent intent = new Intent();
        intent.setClass(context, TsdH5ReaderActivity.class);
        intent.putExtra(TsdConstant.EXTRA_IID, extra_iid);
        context.startActivity(intent);
    }

    @SuppressWarnings("unused")
    public static void openSearchActivity(Context context) {
        Intent intent = new Intent();
        intent.setClass(context, TsdSearchActivity.class);
        context.startActivity(intent);
    }

    @SuppressWarnings("unused")
    public static void setAppId(String appId) {
        TtCloudManager.appId = appId;
    }

    @SuppressWarnings("unused")
    public static IndexFragment getVideoFragment() {
        return IndexFragment.newInstance(IndexFragment.TYPE_VIDEO);
    }

    @SuppressWarnings("unused")
    public static IndexFragment getNewsFragment() {
        return IndexFragment.newInstance(IndexFragment.TYPE_ARTICLE);
    }

    @SuppressWarnings("unused")
    public static IndexFragment getDefaultFragment() {
        return IndexFragment.newInstance();
    }

    /**
     * 切换到夜间模式
     */
    public static void setNightTheme() {
        try {
            TsdSPUtils.put(TsdContextHolder.getContext(), TsdConstant.PRE_THEME, 1);

            EventBus.getDefault().post(new ThemeEvent(1));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 切换到日间模式
     */
    public static void setDayTheme() {
        TsdSPUtils.put(TsdContextHolder.getContext(), TsdConstant.PRE_THEME, 0);
        EventBus.getDefault().post(new ThemeEvent(0));
    }

    /**
     * 获得当前的主题
     * @return 1 ：夜间模式  0:非夜间模式
     */
    public static int getCurrentTheme() {
        return (int) TsdSPUtils.get(TsdContextHolder.getContext(), TsdConstant.PRE_THEME, 0);
    }
}

