package ai.botbrain.ttcloud.api;

import android.view.View;
import android.widget.ImageView;

/**
 * Description：The callback interface class.
 * Creator: Created by peter.
 * Date: 17/5/4.
 */
@SuppressWarnings("unused")
public interface TtCloudListener {

    void onBack(ImageView iv_back);

    /**
     * 分享回调接口，分享成功/失败后需要调用callBack.success()/callBack.fail();
     *
     * @param view     被点击的view
     * @param article  文章信息
     * @param user     用户信息
     * @param callBack callBack
     */
    void onShare(View view, Article article, User user, ResultCallBack callBack);

    void onLiked(Article article, User user);

    /**
     * 评论回调
     *
     * @param view    被点击的view，用于获取Context.
     * @param article 文章信息
     * @param user    用户信息
     */
    void onComment(View view, Article article, User user);

    interface ResultCallBack {
        void success();

        void failed();

        void setUserInfo(User user);
    }

    interface TtCallBack {
        void onError();
    }

    /**
     * 文章的实体类，操作需要返回的参数
     */
    class Article {

        /**
         * 分享参数：缩略图
         */
        String thumb;

        /**
         * 分享参数：内容标题
         */
        String contentTitle;

        /**
         * 分享参数：内容地址
         */
        String contentUrl;

        /**
         * 分享参数：内容描述
         */
        String contentDes;

        /**
         * 文章的Id
         */
        String contentId;

        public String getThumb() {
            return thumb;
        }

        public void setThumb(String thumb) {
            this.thumb = thumb;
        }

        public String getContentTitle() {
            return contentTitle;
        }

        public void setContentTitle(String contentTitle) {
            this.contentTitle = contentTitle;
        }

        public String getContentUrl() {
            return contentUrl;
        }

        public void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        public String getContentDes() {
            return contentDes;
        }

        public void setContentDes(String contentDes) {
            this.contentDes = contentDes;
        }

        public String getContentId() {
            return contentId;
        }

        public void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public String toString() {
            return "Article{" +
                    "thumb='" + thumb + '\'' +
                    ", contentTitle='" + contentTitle + '\'' +
                    ", contentUrl='" + contentUrl + '\'' +
                    ", contentDes='" + contentDes + '\'' +
                    ", contentId='" + contentId + '\'' +
                    '}';
        }
    }

    /**
     * 用户登录需要传递的信息
     */
    class User {

        private String userId;
        private String userName;
        private String userNickName;
        private String userAvatar;

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserNickName() {
            return userNickName;
        }

        public void setUserNickName(String userNickName) {
            this.userNickName = userNickName;
        }

        public String getUserAvatar() {
            return userAvatar;
        }

        public void setUserAvatar(String userAvatar) {
            this.userAvatar = userAvatar;
        }

    }

}
