/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk.tools;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.firedata.sdk.tools.Logy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class DeviceInfo {
    public static final String TAG = "com.firedata.DeviceInfo";
    public static final String OS_NAME = "android";
    private boolean locationListening = true;
    private Context context;
    private CachedInfo cachedInfo;
    private long lastBatteryTime = 0L;
    private int lastBattery = 0;

    public DeviceInfo(Context context) {
        this.context = context;
    }

    private CachedInfo getCachedInfo() {
        if (this.cachedInfo == null) {
            this.cachedInfo = new CachedInfo();
        }
        return this.cachedInfo;
    }

    public void prefetch() {
        this.getCachedInfo();
    }

    public static boolean checkPermission(Context context, String permission) {
        return context.checkCallingOrSelfPermission(permission) == 0;
    }

    public String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public String getOsName() {
        return this.getCachedInfo().osName;
    }

    public String getOsVersion() {
        return this.getCachedInfo().osVersion;
    }

    public String getBrand() {
        return this.getCachedInfo().brand;
    }

    public String getManufacturer() {
        return this.getCachedInfo().manufacturer;
    }

    public String getModel() {
        return this.getCachedInfo().model;
    }

    public String getCarrier() {
        return this.getCachedInfo().carrier;
    }

    public String getImei() {
        return this.getCachedInfo().imei;
    }

    public String getMac() {
        return this.getCachedInfo().mac;
    }

    public String getAppName() {
        return this.getCachedInfo().appName;
    }

    public String getVersionName() {
        return this.getCachedInfo().versionName;
    }

    public int getVersionCode() {
        return this.getCachedInfo().versionCode;
    }

    public long getFirstInstallTime() {
        return this.getCachedInfo().firstInstallTime;
    }

    public long getLastUpdateTime() {
        return this.getCachedInfo().lastUpdateTime;
    }

    public String getInstaller() {
        return this.getCachedInfo().installer;
    }

    public String getCountry() {
        return this.getCachedInfo().country;
    }

    public String getLanguage() {
        return this.getCachedInfo().language;
    }

    public String getTimezone() {
        return this.getCachedInfo().timeZone;
    }

    public int getDisplayWidth() {
        return this.getCachedInfo().width;
    }

    public int getDisplayHeight() {
        return this.getCachedInfo().height;
    }

    public boolean isLimitAdTrackingEnabled() {
        return this.getCachedInfo().limitAdTrackingEnabled;
    }

    public float[] getXYZ() {
        return this.getCachedInfo().xyz;
    }

    public boolean getBluetoothState() {
        try {
            BluetoothAdapter ba = BluetoothAdapter.getDefaultAdapter();
            if (ba == null) {
                return false;
            }
            return ba.isEnabled();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int getElctricity() {
        if (this.lastBatteryTime < System.currentTimeMillis()) {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.context.registerReceiver(null, ifilter);
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            this.lastBattery = level * 100 / scale;
            this.lastBatteryTime = System.currentTimeMillis() + 120000L;
        }
        return this.lastBattery;
    }

    public boolean getHeadset() {
        try {
            AudioManager am = (AudioManager)this.context.getSystemService("audio");
            return am.isWiredHeadsetOn();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean getLandscape() {
        try {
            WindowManager wm = (WindowManager)this.context.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            int r = display.getRotation();
            return r == 1 || r == 3;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Location getMostRecentLocation() {
        if (!this.isLocationListening()) {
            return null;
        }
        try {
            LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
            if (locationManager == null) {
                return null;
            }
            List providers = locationManager.getProviders(true);
            if (providers == null) {
                return null;
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            for (String provider : providers) {
                Location location = null;
                try {
                    location = locationManager.getLastKnownLocation(provider);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (location == null) continue;
                locations.add(location);
            }
            long maximumTimestamp = -1L;
            Location bestLocation = null;
            for (Location location : locations) {
                if (location.getTime() <= maximumTimestamp) continue;
                maximumTimestamp = location.getTime();
                bestLocation = location;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getNetworkType() {
        try {
            ConnectivityManager m = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo n = m.getActiveNetworkInfo();
            if (n == null) {
                return "";
            }
            int type = n.getType();
            if (type == 1) {
                return "WIFI";
            }
            if (type == 0) {
                TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
                return String.valueOf(tm.getNetworkType());
            }
            return "OTHER";
        }
        catch (Exception e) {
            Logy.e(TAG, "Get network type failed");
            e.printStackTrace();
            return "";
        }
    }

    @TargetApi(value=17)
    public int[] getResolution() {
        DisplayMetrics dm;
        Display display;
        int width = -1;
        int height = -1;
        try {
            WindowManager wm = (WindowManager)this.context.getSystemService("window");
            display = wm.getDefaultDisplay();
        }
        catch (NullPointerException e) {
            Logy.e(TAG, "Window service was not available from this context");
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            dm = new DisplayMetrics();
            display.getRealMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method getRawWidth = Display.class.getMethod("getRawWidth", new Class[0]);
                Method getRawHeight = Display.class.getMethod("getRawHeight", new Class[0]);
                width = (Integer)getRawWidth.invoke((Object)display, new Object[0]);
                height = (Integer)getRawHeight.invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                Logy.w(TAG, "Reflection of getRawWidth/getRawHeight failed on API14-16 unexpectedly.");
            }
        }
        if (width == -1 || height == -1) {
            dm = new DisplayMetrics();
            display.getMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        }
        return new int[]{width, height};
    }

    public boolean isLocationListening() {
        return this.locationListening;
    }

    public void setLocationListening(boolean locationListening) {
        this.locationListening = locationListening;
    }

    public String getWifiName() {
        try {
            ConnectivityManager conMan = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo wifi = conMan.getNetworkInfo(1);
            if (wifi.isConnected()) {
                WifiManager wifiManager = (WifiManager)this.context.getSystemService("wifi");
                return wifiManager.getConnectionInfo().getSSID();
            }
            return "";
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    protected Geocoder getGeocoder() {
        return new Geocoder(this.context, Locale.ENGLISH);
    }

    private class CachedInfo {
        private String country;
        private String versionName;
        private int versionCode;
        private long firstInstallTime;
        private long lastUpdateTime;
        private String osName;
        private String osVersion;
        private String brand;
        private String manufacturer;
        private String model;
        private String carrier;
        private String imei;
        private String mac;
        private String language;
        private String timeZone;
        private String appName;
        private String installer;
        private boolean limitAdTrackingEnabled;
        private int width;
        private int height;
        private float[] xyz = new float[3];

        private CachedInfo() {
            this.getAppInfo();
            this.osName = this.getOsName();
            this.osVersion = this.getOsVersion();
            this.brand = this.getBrand();
            this.manufacturer = this.getManufacturer();
            this.model = this.getModel();
            this.carrier = this.getCarrier();
            this.imei = this.getImei();
            this.mac = this.getMac();
            this.appName = this.getAppName();
            this.installer = this.getInstaller();
            this.country = this.getCountry();
            this.language = this.getLanguage();
            this.timeZone = this.getTimeZone();
            int[] res = DeviceInfo.this.getResolution();
            this.width = res[0];
            this.height = res[1];
            this.xyz[0] = 0.0f;
            this.xyz[1] = 0.0f;
            this.xyz[2] = 0.0f;
            this.listenXYZ();
        }

        private void getAppInfo() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                this.versionName = packageInfo.versionName;
                this.versionCode = packageInfo.versionCode;
                this.firstInstallTime = packageInfo.firstInstallTime;
                this.lastUpdateTime = packageInfo.lastUpdateTime;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }

        private void listenXYZ() {
            try {
                SensorManager sm = (SensorManager)DeviceInfo.this.context.getSystemService("sensor");
                if (sm == null) {
                    return;
                }
                Sensor sensor = sm.getDefaultSensor(1);
                if (sensor == null) {
                    return;
                }
                sm.registerListener(new SensorEventListener(){

                    public void onSensorChanged(SensorEvent event) {
                        ((CachedInfo)CachedInfo.this).xyz[0] = event.values[0];
                        ((CachedInfo)CachedInfo.this).xyz[1] = event.values[1];
                        ((CachedInfo)CachedInfo.this).xyz[2] = event.values[2];
                    }

                    public void onAccuracyChanged(Sensor sensor, int accuracy) {
                    }
                }, sensor, 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private String getOsName() {
            return DeviceInfo.OS_NAME;
        }

        private String getOsVersion() {
            return Build.VERSION.RELEASE;
        }

        private String getBrand() {
            return Build.BRAND;
        }

        private String getManufacturer() {
            return Build.MANUFACTURER;
        }

        private String getModel() {
            return Build.MODEL;
        }

        private String getCarrier() {
            try {
                StringBuilder builder = new StringBuilder();
                TelephonyManager telManager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                String operatorName = telManager.getSimOperatorName();
                if (!TextUtils.isEmpty((CharSequence)operatorName)) {
                    builder.append(operatorName);
                } else {
                    operatorName = telManager.getNetworkOperatorName();
                    if (!TextUtils.isEmpty((CharSequence)operatorName)) {
                        builder.append(operatorName);
                    } else {
                        return "";
                    }
                }
                builder.append("_");
                String operator = telManager.getSimOperator();
                if (!TextUtils.isEmpty((CharSequence)operator)) {
                    builder.append(operator);
                }
                if (builder.length() > 1) {
                    return builder.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logy.e(DeviceInfo.TAG, "Get operator failed");
            }
            return "";
        }

        private String getImei() {
            TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
            try {
                return manager.getDeviceId();
            }
            catch (SecurityException e) {
                Logy.w("GET IMEI", "cannot get imei due to permission android.permission.READ_PHONE_STATE");
                return "";
            }
        }

        private String getMac() {
            try {
                WifiManager wifi = (WifiManager)DeviceInfo.this.context.getSystemService("wifi");
                if (wifi == null) {
                    return "";
                }
                WifiInfo info = wifi.getConnectionInfo();
                if (info == null) {
                    return "";
                }
                return info.getMacAddress();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }

        private String getAppName() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                ApplicationInfo appInfo = packageInfo.applicationInfo;
                if (appInfo != null) {
                    return appInfo.loadLabel(DeviceInfo.this.context.getPackageManager()).toString();
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Logy.e(DeviceInfo.TAG, "Error retrieving appName");
            }
            return "";
        }

        private String getCountry() {
            String country = this.getCountryFromLocation();
            if (!TextUtils.isEmpty((CharSequence)country)) {
                return country;
            }
            country = this.getCountryFromNetwork();
            if (!TextUtils.isEmpty((CharSequence)country)) {
                return country;
            }
            return this.getCountryFromLocale();
        }

        private String getCountryFromLocation() {
            if (!DeviceInfo.this.isLocationListening()) {
                return null;
            }
            try {
                Geocoder geocoder;
                List addresses;
                Location recent = DeviceInfo.this.getMostRecentLocation();
                if (recent != null && Geocoder.isPresent() && (addresses = (geocoder = DeviceInfo.this.getGeocoder()).getFromLocation(recent.getLatitude(), recent.getLongitude(), 1)) != null) {
                    for (Address address : addresses) {
                        if (address == null) continue;
                        return address.getCountryCode();
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            return null;
        }

        private String getCountryFromNetwork() {
            try {
                String country;
                TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (manager.getPhoneType() != 2 && (country = manager.getNetworkCountryIso()) != null) {
                    return country.toUpperCase(Locale.US);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private String getCountryFromLocale() {
            return Locale.getDefault().getCountry();
        }

        private String getLanguage() {
            return Locale.getDefault().getLanguage();
        }

        public String getInstaller() {
            String result = "";
            if (Build.VERSION.SDK_INT >= 3) {
                try {
                    result = DeviceInfo.this.context.getPackageManager().getInstallerPackageName(DeviceInfo.this.context.getPackageName());
                }
                catch (Exception e) {
                    Logy.i(DeviceInfo.TAG, "Can't get Installer package");
                }
                if (result == null || result.length() == 0) {
                    result = "";
                    Logy.i(DeviceInfo.TAG, "No installer found");
                }
            }
            return result;
        }

        private String getTimeZone() {
            TimeZone timeZone = TimeZone.getDefault();
            int hours = Math.abs(timeZone.getRawOffset()) / 3600000;
            int minutes = Math.abs(timeZone.getRawOffset() / 60000) % 60;
            String sign = timeZone.getRawOffset() >= 0 ? "+" : "-";
            String timeZoneFormat = String.format(Locale.getDefault(), "T%s%02d:%02d", sign, hours, minutes);
            return timeZoneFormat;
        }
    }
}

