/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class Checksum {
    private static final String HEXES = "0123456789ABCDEF";

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String getMD5Checksum(String string) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(string.getBytes());
        byte[] messageDigest = digest.digest();
        return Checksum.getHex(messageDigest);
    }

    public static String getMD5Checksum(File file) throws Exception {
        int numRead;
        if (!file.isFile()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return Checksum.getHex(complete.digest());
    }
}

