/*
 * Decompiled with CFR 0.152.
 */
package com.youku.cloud.utils.http.async;

import android.util.Log;
import com.youku.cloud.utils.http.HttpGetRequest;
import com.youku.cloud.utils.http.HttpHeadRequest;
import com.youku.cloud.utils.http.HttpPostRequest;
import com.youku.cloud.utils.http.HttpRequest;
import com.youku.cloud.utils.http.RequestParams;
import com.youku.cloud.utils.http.async.AsyncHttpResponse;
import com.youku.cloud.utils.http.async.AsyncTask;
import com.youku.cloud.utils.http.async.HttpMethod;
import com.youku.cloud.utils.http.async.IResponseHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;

public class AsyncHttpRequest
extends AsyncTask<Void, Integer, AsyncHttpResponse> {
    private HttpMethod method;
    private String url;
    private RequestParams params;
    private String userAgent;
    private Map<String, List<Object>> headers;
    private IResponseHandler handler;
    private HttpRequest req;

    public AsyncHttpRequest(HttpMethod method, String url, RequestParams params, String userAgent, Map<String, List<Object>> headers, IResponseHandler handler) {
        this.method = method;
        this.url = url;
        this.params = params;
        this.userAgent = userAgent;
        this.headers = headers;
        this.handler = handler;
        if (method == HttpMethod.POST) {
            this.req = new HttpPostRequest(url);
        } else if (method == HttpMethod.GET) {
            this.req = new HttpGetRequest(url);
        } else if (method == HttpMethod.HEAD) {
            this.req = new HttpHeadRequest(url);
        }
    }

    private void setData(HttpRequest request, AsyncHttpResponse response) throws MalformedURLException, IOException, SocketTimeoutException {
        request.setParameters(this.params);
        request.setUserAgent(this.userAgent);
        request.setHeaders(this.headers);
        int code = request.getResponseCode();
        response.setStatusCode(Integer.valueOf(code));
        response.setHeaders(request.getConnection().getHeaderFields());
        response.setServertime(request.getServerTime());
        if (code >= 300) {
            response.setThrowable(new Throwable(code + ""));
        }
        String str = request.getResponseBody();
        response.setResponse(str);
    }

    public void setTimeout(int timeout) {
        this.req.setConnectTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncHttpResponse doInBackground(Void ... v) {
        AsyncHttpResponse response = new AsyncHttpResponse();
        try {
            this.setData(this.req, response);
        }
        catch (MalformedURLException var9) {
            response.setThrowable((Throwable)var9);
        }
        catch (SocketTimeoutException var10) {
            response.setThrowable((Throwable)var10);
        }
        catch (IOException var11) {
            response.setThrowable((Throwable)var11);
        }
        finally {
            this.req.close();
        }
        return response;
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.handler != null) {
            this.handler.onCancelled();
            this.handler.onFinished();
        }
    }

    protected void onPostExecute(AsyncHttpResponse result) {
        super.onPostExecute((Object)result);
        if (this.handler != null) {
            if (result.getThrowable() != null) {
                if (result.getThrowable() instanceof SocketTimeoutException) {
                    this.handler.onTimeout();
                } else if (result != null) {
                    if (result.getStatusCode() != null) {
                        this.handler.onFailure(result.getStatusCode().intValue(), result.getHeaders(), result.getResponse(), result.getThrowable());
                    } else {
                        this.handler.onFailure(-1, result.getHeaders(), result.getResponse(), result.getThrowable());
                    }
                }
            } else {
                Log.i((String)"lugq", (String)result.getResponse());
                String response = result.getResponse();
                response = "{}";
                this.handler.onSuccess(result.getStatusCode().intValue(), result.getHeaders(), response);
                this.handler.onGetServerTime(result.getServertime());
            }
            this.handler.onFinished();
        }
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.handler != null) {
            this.handler.onStart();
        }
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.handler != null) {
            // empty if block
        }
    }
}

