/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.Toast;

public class NetChangeUtil {
    public static final int NETWORKTYPE_INVALID = 0;
    public static final int NETWORKTYPE_WAP = 1;
    public static final int NETWORKTYPE_2G = 2;
    public static final int NETWORKTYPE_3G = 3;
    public static final int NETWORKTYPE_WIFI = 4;
    public static int mNetWorkType;

    public static int getNetWorkType(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo == null) {
            Toast.makeText((Context)context, (CharSequence)"\u7f51\u7edc\u672a\u8fde\u63a5", (int)0).show();
        }
        if (networkInfo != null) {
            String type = networkInfo.getTypeName();
            if (networkInfo != null && networkInfo.isConnected()) {
                if (type != null && type.equalsIgnoreCase("WIFI")) {
                    mNetWorkType = 4;
                } else if (type != null && type.equalsIgnoreCase("MOBILE")) {
                    String proxyHost = Proxy.getDefaultHost();
                    mNetWorkType = TextUtils.isEmpty((CharSequence)proxyHost) ? (NetChangeUtil.isFastMobileNetwork(context) ? 3 : 2) : 1;
                }
            }
        }
        return mNetWorkType;
    }

    public static boolean isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }
}

