/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5Activity;
import ai.botbrain.ttcloud.sdk.activity.TsdVideoFullscreenActivity;
import ai.botbrain.ttcloud.sdk.adapter.CardStyle2Adapter;
import ai.botbrain.ttcloud.sdk.adapter.SecondaryDirectoryAdapter;
import ai.botbrain.ttcloud.sdk.adapter.TsdCardStyle1Adapter;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupUtil;
import ai.botbrain.ttcloud.sdk.model.Ad360Entity;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.DownLoadApkManager;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.AdQqManager;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.NetworkUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.widget.AnthologyDialog;
import ai.botbrain.ttcloud.sdk.widget.CommonDialog;
import ai.botbrain.ttcloud.sdk.widget.NetDialog;
import ai.botbrain.ttcloud.sdk.widget.NoScrollGridView;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.InflateException;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ak.android.engine.nav.NativeAd;
import com.ak.android.engine.nav.NativeAdLoaderListener;
import com.ak.android.engine.navbase.NativeAdLoader;
import com.ak.android.shell.AKAD;
import com.baidu.mobad.feeds.BaiduNative;
import com.baidu.mobad.feeds.NativeErrorCode;
import com.baidu.mobad.feeds.NativeResponse;
import com.baidu.mobad.feeds.RequestParameters;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.firedata.sdk.Firedata;
import com.firedata.sdk.Props;
import com.qq.e.ads.nativ.NativeMediaAD;
import com.qq.e.ads.nativ.NativeMediaADData;
import com.youku.cloud.module.PlayerErrorInfo;
import com.youku.cloud.player.PlayerListener;
import com.youku.cloud.player.VideoDefinition;
import com.youku.cloud.player.YoukuPlayerView;
import com.youku.cloud.player.YoukuUIListener;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class RecommendHomeAdapter
extends BaseAdapter {
    private static final String TAG = RecommendHomeAdapter.class.getSimpleName();
    private final Context mContext;
    private RestApi restApi;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private static final int TYPE_CARD_STYLE1 = 0;
    private static final int TYPE_CARD_STYLE2 = 1;
    private static final int TYPE_VIDEO_STYLE_DEFAULT = 2;
    private static final int TYPE_QQ_AD = 3;
    private static final int TYPE_360_AD = 4;
    private static final int TYPE_BAIDU_AD = 5;
    private static final int TYPE_BOTBRAIN_AD = 6;
    private static final int TYPE_FILM = 7;
    private static final int TYPE_SUBCOLUMNS = 8;
    private static final int TYPE_NO_PIC = 9;
    private static final int TYPE_ONE_SMALL = 10;
    private static final int TYPE_ONE_BIG = 11;
    private static final int TYPE_THREE_PIC = 12;
    private static final int TYPE_SEE_HERE = 13;
    private static final int TYPE_COUNT = 14;
    private static final String CARD_STYLE1 = "1";
    private static final String CARD_STYLE2 = "2";
    private static final String TYPE_CARD = "card";
    private List<RecommendEntity.Data> mData;
    private String iid;
    private String extraVid;
    private List<TopTitleEntity.SubColumns> mSubColumnses;
    private NetDialog mNetDialog;
    public YoukuPlayerView youkuPlayerView;
    public int currentPlayingPosition = 0;
    private RequestOptions options_common = new RequestOptions().centerCrop().placeholder(R.drawable.tsd_bg_place).error(R.drawable.tsd_bg_place).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC).skipMemoryCache(false).priority(Priority.HIGH);
    private NotiListener mNotiListener;

    public RecommendHomeAdapter(Context context, List<RecommendEntity.Data> data, List<TopTitleEntity.SubColumns> columns) {
        this.mContext = context;
        this.restApi = new RestApiImpl();
        this.mData = data;
        this.mSubColumnses = columns;
        this.mNetDialog = new NetDialog(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YoukuPlayerView getYoukuPlayerView() {
        RecommendHomeAdapter recommendHomeAdapter = this;
        synchronized (recommendHomeAdapter) {
            try {
                if (this.youkuPlayerView == null) {
                    View youku_player = View.inflate((Context)this.mContext, (int)R.layout.tsd_view_youku, null);
                    this.youkuPlayerView = (YoukuPlayerView)youku_player.findViewById(R.id.baseview);
                    ViewGroup group = (ViewGroup)this.youkuPlayerView.getParent();
                    group.removeAllViewsInLayout();
                } else {
                    int childCount;
                    ViewGroup group = (ViewGroup)this.youkuPlayerView.getParent();
                    if (group != null && (childCount = group.getChildCount()) > 1) {
                        group.removeViewAt(1);
                    }
                }
            }
            catch (InflateException e) {
                e.printStackTrace();
            }
        }
        return this.youkuPlayerView;
    }

    public int getCount() {
        int i = 0;
        if (this.mSubColumnses != null && this.mSubColumnses.size() > 0) {
            i = 1;
        }
        return null == this.mData ? i : this.mData.size();
    }

    public Object getItem(int i) {
        return this.mData.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public int getViewTypeCount() {
        return 14;
    }

    public int getItemViewType(int position) {
        String style2;
        if (position == 0 && this.mSubColumnses != null && this.mSubColumnses.size() > 0) {
            return 8;
        }
        RecommendEntity.Data data = this.mData.get(position);
        String type = data.type;
        String string2 = style2 = data.style == null ? "" : data.style;
        if (type.equals("film")) {
            return 7;
        }
        if (type.equals(TYPE_CARD) && style2.equals(CARD_STYLE1)) {
            return 0;
        }
        if (type.equals(TYPE_CARD) && style2.equals(CARD_STYLE2)) {
            return 1;
        }
        if (type.equals("ad") && data.data.src.equals("botbrain")) {
            return 6;
        }
        if (type.equals("ad") && data.data.src.equals("qq.e")) {
            return 3;
        }
        if (type.equals("ad") && data.data.src.equals("baidu")) {
            return 5;
        }
        if (type.equals("ad") && data.data.src.equals("360")) {
            return 4;
        }
        if (type.equals("feed")) {
            RecommendEntity.Data2 data2 = data.data;
            String[] imgs = data2.images;
            String coverUrl = data2.cover_url;
            if (!TextUtils.isEmpty((CharSequence)coverUrl)) {
                return 11;
            }
            if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length == 0) {
                return 9;
            }
            if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length == 1) {
                return 10;
            }
            if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length >= 3) {
                return 12;
            }
            return 9;
        }
        return 2;
    }

    private void initViewDisLike(View convertView, ViewHolder viewHolder) {
        viewHolder.iv_dislike = (ImageView)convertView.findViewById(R.id.iv_dislike);
        viewHolder.iv_dislike.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int position2 = (Integer)v.getTag();
                RecommendHomeAdapter.this.initPopup(v, position2);
            }
        });
    }

    private void initViewCommon(View convertView, ViewHolder viewHolder) {
        viewHolder.mTitle = (TextView)convertView.findViewById(R.id.item_title);
        viewHolder.mSource = (TextView)convertView.findViewById(R.id.item_source);
        viewHolder.tsd_tv_stickied = (TextView)convertView.findViewById(R.id.tsd_tv_stickied);
        viewHolder.tsd_article_divider = convertView.findViewById(R.id.tsd_article_divider);
    }

    public View getView(int position, View convertView, ViewGroup viewGroup) {
        ViewHolder viewHolder;
        int currentType = this.getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            switch (currentType) {
                case 0: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_card_style1_gridview, null);
                    viewHolder.tv_name = (TextView)convertView.findViewById(R.id.tv_name);
                    viewHolder.btn_more = (Button)convertView.findViewById(R.id.btn_more);
                    viewHolder.listview_item_gridview = (NoScrollGridView)convertView.findViewById(R.id.listview_item_gridview);
                    break;
                }
                case 1: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_card_style2_gridview, null);
                    viewHolder.tv_name = (TextView)convertView.findViewById(R.id.tv_name);
                    viewHolder.btn_more = (Button)convertView.findViewById(R.id.btn_more);
                    viewHolder.listview_item_gridview = (NoScrollGridView)convertView.findViewById(R.id.listview_item_gridview);
                    break;
                }
                case 2: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_short_video, null);
                    viewHolder.iv_pic = (ImageView)convertView.findViewById(R.id.iv_pic);
                    viewHolder.container = (FrameLayout)convertView.findViewById(R.id.container);
                    viewHolder.iv_play = (ImageView)convertView.findViewById(R.id.iv_play);
                    viewHolder.tv_left_up = (TextView)convertView.findViewById(R.id.tv_left_up);
                    viewHolder.tv_left_down = (TextView)convertView.findViewById(R.id.tv_left_down);
                    viewHolder.tv_right_down = (TextView)convertView.findViewById(R.id.tv_right_down);
                    viewHolder.rl_bg = (RelativeLayout)convertView.findViewById(R.id.rl_bg);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_qq_ad2, null);
                    viewHolder.adInfoContainer = (LinearLayout)convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView)convertView.findViewById(R.id.img_logo);
                    viewHolder.iv_ad = (ImageView)convertView.findViewById(R.id.iv_ad);
                    viewHolder.poster = (ImageView)convertView.findViewById(R.id.img_poster);
                    viewHolder.name = (TextView)convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView)convertView.findViewById(R.id.text_desc);
                    viewHolder.download = (Button)convertView.findViewById(R.id.btn_download);
                    viewHolder.rl_ad = (RelativeLayout)convertView.findViewById(R.id.rl_ad);
                    break;
                }
                case 5: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_baidu_ad, null);
                    viewHolder.adInfoContainer = (LinearLayout)convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView)convertView.findViewById(R.id.img_logo);
                    viewHolder.iv_ad = (ImageView)convertView.findViewById(R.id.iv_ad);
                    viewHolder.img_baidu_poster = (ImageView)convertView.findViewById(R.id.img_baidu_poster);
                    viewHolder.name = (TextView)convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView)convertView.findViewById(R.id.text_desc);
                    viewHolder.rl_ad = (RelativeLayout)convertView.findViewById(R.id.rl_ad);
                    break;
                }
                case 7: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_movie, null);
                    viewHolder.tvTittle = (TextView)convertView.findViewById(R.id.tv_title);
                    viewHolder.tvNew = (TextView)convertView.findViewById(R.id.tv_gengxin);
                    viewHolder.tvDir = (TextView)convertView.findViewById(R.id.tv_daoyan);
                    viewHolder.tvAct = (TextView)convertView.findViewById(R.id.tv_zhuyan);
                    viewHolder.pic = (ImageView)convertView.findViewById(R.id.pic);
                    viewHolder.lin = (LinearLayout)convertView.findViewById(R.id.lin);
                    viewHolder.tv_line2 = (TextView)convertView.findViewById(R.id.tv_line2);
                    break;
                }
                case 8: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_sec_dire, null);
                    viewHolder.gridView = (NoScrollGridView)convertView.findViewById(R.id.listview_item_gridview);
                    break;
                }
                case 13: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_see_here, null);
                    break;
                }
                case 9: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_plain, null);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 10: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_small, null);
                    viewHolder.mRightImage = (ImageView)convertView.findViewById(R.id.right_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 12: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_multi_pics, null);
                    viewHolder.mImageLeft = (ImageView)convertView.findViewById(R.id.left_image);
                    viewHolder.mImageMid = (ImageView)convertView.findViewById(R.id.mid_image);
                    viewHolder.mImageRight = (ImageView)convertView.findViewById(R.id.right_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 11: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_big_pic, null);
                    viewHolder.mBigImage = (ImageView)convertView.findViewById(R.id.big_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                }
            }
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (null != convertView) {
            convertView.setId(position);
        }
        if (currentType == 8) {
            this.renderSubColumns(viewHolder);
        } else if (currentType == 0) {
            this.renderCardStyle1(viewHolder, position);
        } else if (currentType == 1) {
            this.renderCardStyle2(viewHolder, position);
        } else if (currentType == 2) {
            this.renderVideoStyleDefault(viewHolder, position);
        } else if (currentType == 3) {
            this.renderQQAd(viewHolder, position, convertView);
        } else if (currentType == 4) {
            this.render360Ad(viewHolder, position, convertView);
        } else if (currentType == 5) {
            this.renderBaiduAd(viewHolder, position, convertView);
        } else if (currentType == 6) {
            this.renderBotAd(viewHolder, position, convertView);
        } else if (currentType == 7) {
            this.renderFilm(viewHolder, position, convertView);
        } else if (currentType == 12 || currentType == 9 || currentType == 10 || currentType == 11) {
            String flag;
            viewHolder.iv_dislike.setTag((Object)position);
            viewHolder.mTitle.setTextSize((float)TsdContextHolder.getFont_size());
            RecommendEntity.Data data = this.mData.get(position);
            RecommendEntity.Data2 data2 = data.data;
            if (data2 == null) {
                return convertView;
            }
            boolean has_read = data2.has_read;
            String channel = data2.channel == null ? "" : data2.channel;
            String coverUrl = data2.cover_url == null ? "" : data2.cover_url;
            String[] images = data2.images;
            String string2 = flag = data.flag == null ? "" : data.flag;
            if (flag.equals("top")) {
                viewHolder.tsd_tv_stickied.setVisibility(0);
            } else {
                viewHolder.tsd_tv_stickied.setVisibility(8);
            }
            viewHolder.mTitle.setText((CharSequence)data2.title);
            if (has_read) {
                viewHolder.mTitle.setTextColor(this.mContext.getResources().getColor(R.color.tsd_color_feed_item_text_hasread));
            } else {
                viewHolder.mTitle.setTextColor(this.mContext.getResources().getColor(R.color.tsd_color_feed_item_text));
            }
            viewHolder.mSource.setText((CharSequence)channel);
            if (currentType == 11) {
                Glide.with((Context)this.mContext).load((Object)coverUrl).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mBigImage);
            } else if (currentType == 10) {
                Glide.with((Context)this.mContext).load((Object)images[0]).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mRightImage);
            } else if (currentType == 12) {
                Glide.with((Context)this.mContext).setDefaultRequestOptions(this.options_common).load((Object)images[0]).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mImageLeft);
                Glide.with((Context)this.mContext).applyDefaultRequestOptions(this.options_common).load((Object)images[1]).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mImageMid);
                Glide.with((Context)this.mContext).load((Object)images[2]).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mImageRight);
            }
            if (position + 1 < this.mData.size()) {
                RecommendEntity.Data data22 = this.mData.get(position + 1);
                if (data22.type.equals("seeHere")) {
                    viewHolder.tsd_article_divider.setVisibility(8);
                } else {
                    viewHolder.tsd_article_divider.setVisibility(0);
                }
            }
        }
        return convertView;
    }

    private void startDownApk(String apkUrl, String apkName) {
        DownLoadApkManager downLoadApkManager = new DownLoadApkManager(TsdContextHolder.getContext());
        downLoadApkManager.downloadApk(apkUrl, apkName);
    }

    private void openH5Activity(String webAddress, String title) {
        Intent intent = new Intent();
        intent.putExtra("webAddress", webAddress);
        intent.putExtra("title", title);
        intent.setClass(this.mContext, TsdH5Activity.class);
        this.mContext.startActivity(intent);
    }

    public synchronized void initPlayer(YoukuPlayerView youkuPlayerView) {
        youkuPlayerView.release();
        youkuPlayerView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                return false;
            }
        });
        youkuPlayerView.attachActivity((Activity)this.mContext);
        youkuPlayerView.setPreferVideoDefinition(VideoDefinition.VIDEO_HD);
        youkuPlayerView.setPlayerListener((PlayerListener)new MyPlayerListener());
        youkuPlayerView.setUseOrientation(false);
        youkuPlayerView.setUIListener(new YoukuUIListener(){

            public void onBackBtnClick() {
            }

            public void onFullBtnClick() {
                Intent intent = new Intent();
                intent.setClass(RecommendHomeAdapter.this.mContext, TsdVideoFullscreenActivity.class);
                intent.putExtra("vid", RecommendHomeAdapter.this.extraVid);
                RecommendHomeAdapter.this.mContext.startActivity(intent);
            }
        });
    }

    private void adExposure(NativeMediaADData nativeMediaADData) {
        LogUtil.i(TAG, nativeMediaADData.getTitle() + " onADExposure");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(nativeMediaADData.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(nativeMediaADData.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        EventBus.getDefault().post((Object)new BuriedPointEvent("adshow", null, null, params, null));
        FireDataManager.qqAdShow(nativeMediaADData);
    }

    private void adClick(NativeMediaADData ad) {
        LogUtil.i(TAG, ad.getTitle() + " onADClicked");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(ad.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(ad.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        this.restApi.adClickHttp(params);
        FireDataManager.qqAdClick(ad);
    }

    private void setDatas(List data, int position) {
        try {
            RecommendEntity.Data data1 = (RecommendEntity.Data)data.get(position);
            RecommendEntity.Data2 data2 = data1.data;
            data2.isContainYouKu = true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public boolean resetDatas() {
        boolean flag = false;
        try {
            for (RecommendEntity.Data obj : this.mData) {
                if (!(obj instanceof RecommendEntity.Data)) continue;
                RecommendEntity.Data data = obj;
                if (null == data.data || !data.data.isContainYouKu) continue;
                data.data.isContainYouKu = false;
                flag = true;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return flag;
    }

    private String getLabel_id(String channel) {
        String label_id = "tv";
        if (TextUtils.isEmpty((CharSequence)channel)) {
            return label_id;
        }
        if (channel.equals(this.mContext.getResources().getString(R.string.tsd_tv_series))) {
            label_id = "tv";
        } else if (channel.equals(this.mContext.getResources().getString(R.string.tsd_movie))) {
            label_id = "movie";
        } else if (channel.equals(this.mContext.getResources().getString(R.string.tsd_variety))) {
            label_id = "zongyi";
        } else if (channel.equals(this.mContext.getResources().getString(R.string.tsd_anime))) {
            label_id = "cartoon";
        }
        return label_id;
    }

    private StringBuffer getTypes(List<String> types) {
        StringBuffer str1 = new StringBuffer();
        if (types.size() > 8) {
            for (int i = 0; i < 8; ++i) {
                str1.append(types.get(i)).append(this.mContext.getResources().getString(R.string.tsd_str_empty));
            }
        } else {
            for (int i = 0; i < types.size(); ++i) {
                str1.append(types.get(i)).append(this.mContext.getResources().getString(R.string.tsd_str_empty));
            }
        }
        return str1;
    }

    private StringBuffer getActors(List<String> actors) {
        StringBuffer str1 = new StringBuffer();
        if (actors.size() > 6) {
            for (int i = 0; i < 6; ++i) {
                str1.append(actors.get(i)).append(this.mContext.getResources().getString(R.string.tsd_str_empty));
            }
        } else {
            for (int i = 0; i < actors.size(); ++i) {
                str1.append(actors.get(i)).append(this.mContext.getResources().getString(R.string.tsd_str_empty));
            }
        }
        return str1;
    }

    private String getMoveShowTime(String pub_time) {
        if (pub_time != null && pub_time.length() > 4) {
            return pub_time.substring(0, 4);
        }
        return pub_time;
    }

    private void renderSubColumns(ViewHolder viewHolder) {
        SecondaryDirectoryAdapter secondaryDirectoryAdapter = new SecondaryDirectoryAdapter(this.mContext, this.mSubColumnses);
        viewHolder.gridView.setAdapter((ListAdapter)secondaryDirectoryAdapter);
    }

    private void renderFilm(ViewHolder viewHolder, int position, View convertView) {
        RecommendEntity.Data e = this.mData.get(position);
        final RecommendEntity.Data2 entity = e.data;
        List<String> directors = entity.directors;
        List<String> areas = entity.areas;
        List<String> types = entity.types;
        List<String> actors = entity.actors;
        RecommendEntity.Newest newest = entity.newest;
        final String channel = null == entity.channel ? "" : entity.channel;
        String pub_time = null == entity.pub_time ? "" : entity.pub_time;
        String picurl = null == entity.picurl ? "" : entity.picurl;
        String d_score = null == entity.d_score ? "" : entity.d_score;
        String area = null == areas || areas.size() == 0 ? "" : areas.get(0);
        String director = null == directors || directors.size() == 0 ? "" : directors.get(0);
        Boolean is_all = entity.is_all;
        StringBuffer str_type = this.getTypes(types);
        String episode = null == newest || null == newest.episode ? "" : newest.episode;
        final String title = null == entity.title ? "" : entity.title;
        final String label_id = this.getLabel_id(channel);
        final String iid = null == entity.iid ? "" : entity.iid;
        final Object alg = null == entity.alg ? "" : entity.alg;
        Glide.with((Context)this.mContext).load((Object)picurl).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.pic);
        viewHolder.tvTittle.setText((CharSequence)title);
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                Props props = new Props();
                props.event("iid", (Object)entity.iid).event("alg", (Object)entity.alg.toString());
                Firedata.event((String)(label_id + "_" + label_id), (String)"click", (Props)props);
                if (channel.equals(RecommendHomeAdapter.this.mContext.getResources().getString(R.string.tsd_movie))) {
                    FireDataManager.clickContent(label_id, title, iid);
                    EventBus.getDefault().post((Object)new BuriedPointEvent("click", iid, alg, null, null));
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread(){

                            @Override
                            public void run() {
                                super.run();
                                FireDataManager.play(RecommendHomeAdapter.this.getLabel_id(channel));
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                RecommendHomeAdapter.this.mainHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FireDataManager.play(RecommendHomeAdapter.this.getLabel_id(channel));
                                        JsPresenter.getInstance().StartPlayback(RecommendHomeAdapter.this.mContext, entity.url, title, iid);
                                    }
                                });
                            }
                        }.start();
                    } else {
                        FireDataManager.play(RecommendHomeAdapter.this.getLabel_id(channel));
                        JsPresenter.getInstance().StartPlayback(RecommendHomeAdapter.this.mContext, entity.url, entity.title, iid);
                    }
                } else {
                    RecommendHomeAdapter.this.showAnthologyDialog(entity);
                }
            }
        });
        String movie = this.mContext.getResources().getString(R.string.tsd_movie);
        String variety = this.mContext.getResources().getString(R.string.tsd_variety);
        String anime = this.mContext.getResources().getString(R.string.tsd_anime);
        if (!entity.channel.equals(movie)) {
            viewHolder.tvNew.setVisibility(0);
            viewHolder.lin.setVisibility(8);
            if (is_all.booleanValue() && episode.length() <= 6) {
                String all_episodes = this.mContext.getResources().getString(R.string.tsd_all_episodes);
                viewHolder.tvNew.setText((CharSequence)String.format(all_episodes, episode));
            } else {
                String tv_series_update_stat = this.mContext.getResources().getString(R.string.tv_series_update_stat);
                viewHolder.tvNew.setText((CharSequence)String.format(tv_series_update_stat, episode));
            }
        } else {
            viewHolder.tvNew.setVisibility(8);
            viewHolder.lin.setVisibility(0);
            String move_line2 = this.mContext.getResources().getString(R.string.tsd_move_line2);
            viewHolder.tv_line2.setText((CharSequence)String.format(move_line2, this.getMoveShowTime(pub_time), d_score));
        }
        if (channel.equals(variety) || channel.equals(anime)) {
            String area_status = this.mContext.getResources().getString(R.string.tsd_area_status);
            viewHolder.tvDir.setText((CharSequence)String.format(area_status, area));
            String type_status = this.mContext.getResources().getString(R.string.tsd_type_status);
            viewHolder.tvAct.setText((CharSequence)String.format(type_status, str_type));
        } else {
            String director_status = this.mContext.getResources().getString(R.string.tsd_director_status);
            viewHolder.tvDir.setText((CharSequence)String.format(director_status, director));
            String starring = this.mContext.getResources().getString(R.string.tsd_starring);
            viewHolder.tvAct.setText((CharSequence)String.format(starring, this.getActors(actors)));
        }
    }

    private void showAnthologyDialog(RecommendEntity.Data2 entity) {
        AnthologyDialog dialog = new AnthologyDialog(this.mContext, entity);
        dialog.show();
    }

    private void renderBotAd(ViewHolder viewHolder, int position, View convertView) {
        String url;
        RecommendEntity.Data data = this.mData.get(position);
        final RecommendEntity.Data2 data1 = data.data;
        final String title = null == data1.title ? "" : data1.title;
        String desc = null == data1.des ? "" : data1.des;
        String pic_url = null == data1.pic_url ? "" : data1.pic_url;
        final String type = null == data1.type ? "" : data1.type;
        String string2 = url = null == data1.url ? "" : data1.url;
        if (type.equals("apk")) {
            String download = this.mContext.getResources().getString(R.string.tsd_download);
            viewHolder.download.setText((CharSequence)download);
        } else if (type.equals("h5")) {
            String rs_browse = this.mContext.getResources().getString(R.string.tsd_browse);
            viewHolder.download.setText((CharSequence)rs_browse);
        }
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FireDataManager.botAdClick(data1);
                RecommendHomeAdapter.this.restApi.adClickHttp(GsonUtil.GsonString(data1));
                if (type.equals("apk")) {
                    RecommendHomeAdapter.this.startDownApk(url, title);
                } else if (type.equals("h5")) {
                    RecommendHomeAdapter.this.openH5Activity(url, title);
                }
            }
        });
        viewHolder.name.setText((CharSequence)title);
        viewHolder.desc.setText((CharSequence)desc);
        Glide.with((Context)this.mContext).load((Object)pic_url).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
    }

    private void fetBaiduAd(final RecommendEntity.Data2 data2) {
        String AD_PLACE_ID = data2.appid;
        BaiduNative baidu = new BaiduNative(this.mContext, AD_PLACE_ID, new BaiduNative.BaiduNativeNetworkListener(){

            public void onNativeFail(NativeErrorCode arg0) {
                Log.i((String)TAG, (String)("" + arg0.name()));
            }

            public void onNativeLoad(List<NativeResponse> arg0) {
                if (arg0 != null && arg0.size() > 0) {
                    NativeResponse response = arg0.get(0);
                    if (data2.response == null) {
                        data2.response = response;
                        if (null != RecommendHomeAdapter.this.mNotiListener) {
                            RecommendHomeAdapter.this.mNotiListener.notifyData();
                        }
                    }
                }
            }
        });
        RequestParameters requestParameters = new RequestParameters.Builder().downloadAppConfirmPolicy(1).build();
        baidu.makeRequest(requestParameters);
    }

    private void renderBaiduAd(ViewHolder viewHolder, int position, View convertView) {
        RecommendEntity.Data data = this.mData.get(position);
        final RecommendEntity.Data2 data2 = data.data;
        NativeResponse response = data2.response;
        if (null == response) {
            this.fetBaiduAd(data2);
        }
        String desc = null == response ? "" : response.getDesc();
        String imageUrl = null == response ? "" : response.getImageUrl();
        String title = null == response ? "" : response.getTitle();
        viewHolder.desc.setText((CharSequence)(desc + "'"));
        viewHolder.name.setText((CharSequence)title);
        Glide.with((Context)this.mContext).setDefaultRequestOptions(this.options_common).load((Object)imageUrl).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.img_baidu_poster);
        if (null != response) {
            response.recordImpression(convertView);
        }
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    NativeResponse response = data2.response;
                    response.handleClick(v);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fetch360Ad(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        NativeAdLoader adLoader = AKAD.getNativeAdLoader((Context)TsdContextHolder.getContext(), (String)adPlaceId, (NativeAdLoaderListener)new NativeAdLoaderListener(){

            public void onAdLoadSuccess(ArrayList<NativeAd> arrayList) {
                if (null != arrayList && arrayList.size() > 0) {
                    NativeAd ad;
                    data2.nativeAd = ad = arrayList.get(0);
                    if (null != RecommendHomeAdapter.this.mNotiListener) {
                        RecommendHomeAdapter.this.mNotiListener.notifyData();
                    }
                }
            }

            public void onAdLoadFailed(int i, String s) {
                LogUtil.i(TAG, "i:" + i + ",s:" + s);
            }
        });
        adLoader.loadAds();
    }

    private void render360Ad(ViewHolder viewHolder, int position, View convertView) {
        viewHolder.rl_ad.setVisibility(0);
        viewHolder.iv_ad.setVisibility(8);
        RecommendEntity.Data data = this.mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeAd nativeAd = data2.nativeAd;
        if (null == nativeAd) {
            this.fetch360Ad(data2);
        }
        try {
            String json = null;
            Ad360Entity ad360Entity = null;
            if (null != nativeAd) {
                json = nativeAd.getContent().toString();
            }
            if (null != json) {
                ad360Entity = GsonUtil.GsonToBean(json, Ad360Entity.class);
            }
            String ext_text = null == ad360Entity || null == ad360Entity.ext_text ? "" : ad360Entity.ext_text;
            String title = null == ad360Entity || null == ad360Entity.title ? "" : ad360Entity.title;
            String contentimg = null == ad360Entity || null == ad360Entity.contentimg ? "" : ad360Entity.contentimg;
            String btntext = null == ad360Entity || null == ad360Entity.btntext ? "" : ad360Entity.btntext;
            viewHolder.name.setText((CharSequence)ext_text);
            viewHolder.desc.setText((CharSequence)(title + "."));
            viewHolder.iv_ad.setVisibility(8);
            Glide.with((Context)this.mContext).load((Object)contentimg).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
            viewHolder.download.setText((CharSequence)btntext);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null == nativeAd) {
                        return;
                    }
                    nativeAd.onAdClick((Activity)RecommendHomeAdapter.this.mContext, v);
                }
            });
            if (null != nativeAd) {
                nativeAd.onAdShowed(convertView);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchQqAd(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        String nativeVideoPosID = data2.nativevideoposid;
        NativeMediaAD mediaAD = new NativeMediaAD(TsdContextHolder.getContext(), adPlaceId, nativeVideoPosID, new NativeMediaAD.NativeMediaADListener(){

            public void onADLoaded(List<NativeMediaADData> list) {
                if (null != list && list.size() > 0) {
                    NativeMediaADData nativeMediaADData;
                    data2.nativeMediaADData = nativeMediaADData = list.get(0);
                    if (null != RecommendHomeAdapter.this.mNotiListener) {
                        RecommendHomeAdapter.this.mNotiListener.notifyData();
                    }
                }
            }

            public void onNoAD(int errorCode) {
                LogUtil.i(TAG, "\u52a0\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errorCode);
                CommonUtil.clearAppidQ(RecommendHomeAdapter.this.mContext.getApplicationContext());
            }

            public void onADStatusChanged(NativeMediaADData nativeMediaADData) {
            }

            public void onADError(NativeMediaADData nativeMediaADData, int i) {
            }

            public void onADVideoLoaded(NativeMediaADData nativeMediaADData) {
            }

            public void onADExposure(NativeMediaADData nativeMediaADData) {
                RecommendHomeAdapter.this.adExposure(nativeMediaADData);
            }

            public void onADClicked(NativeMediaADData nativeMediaADData) {
                RecommendHomeAdapter.this.adClick(nativeMediaADData);
            }
        });
        mediaAD.loadAD(1);
    }

    private void renderQQAd(ViewHolder viewHolder, int position, View convertView) {
        viewHolder.iv_ad.setVisibility(0);
        viewHolder.rl_ad.setVisibility(8);
        viewHolder.poster.setVisibility(0);
        RecommendEntity.Data data = this.mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeMediaADData ad = data2.nativeMediaADData;
        if (null == ad) {
            this.fetchQqAd(data2);
        }
        String ad_img = null == ad ? "" : ad.getImgUrl();
        String title = null == ad ? "" : ad.getTitle();
        String iconUrl = null == ad ? "" : ad.getIconUrl();
        String desc = null == ad ? "" : ad.getDesc();
        viewHolder.name.setText((CharSequence)title);
        viewHolder.desc.setText((CharSequence)desc);
        Glide.with((Context)this.mContext).load((Object)ad_img).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
        Glide.with((Context)this.mContext).load((Object)(TextUtils.isEmpty((CharSequence)iconUrl) ? ad_img : iconUrl)).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.logo);
        viewHolder.download.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != ad) {
                    ad.onClicked(v);
                }
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null == ad) {
                    return;
                }
                FireDataManager.qqAdClick(ad);
                ad.onClicked(view);
                AdEntity adEntity = new AdEntity();
                adEntity.setDes(ad.getDesc());
                adEntity.setSrc("qq.e");
                adEntity.setTitle(ad.getTitle());
                String params = GsonUtil.GsonString(adEntity);
                RecommendHomeAdapter.this.restApi.adClickHttp(params);
            }
        });
        AdQqManager.renderDownLoadView(viewHolder.download, ad);
        if (null != ad) {
            ad.onExposured((View)viewHolder.adInfoContainer);
        }
    }

    private void renderCardStyle1(ViewHolder viewHolder, int position) {
        RecommendEntity.Data mData = this.mData.get(position);
        List<RecommendEntity.Datas> dataList = mData.datas;
        RecommendEntity.More more = mData.more;
        String moreName = null == more.name ? "" : more.name;
        final String moreAction = null == more.action ? "" : more.action;
        String name = null == mData.name ? "" : mData.name;
        TsdCardStyle1Adapter cardStyle1Adapter = new TsdCardStyle1Adapter(this.mContext, dataList);
        viewHolder.tv_name.setText((CharSequence)name);
        viewHolder.btn_more.setText((CharSequence)moreName);
        viewHolder.listview_item_gridview.setAdapter((ListAdapter)cardStyle1Adapter);
        viewHolder.btn_more.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EventBus.getDefault().post((Object)moreAction);
                FireDataManager.clickMore();
            }
        });
    }

    private void renderCardStyle2(ViewHolder viewHolder, int position) {
        RecommendEntity.Data data = this.mData.get(position);
        List<RecommendEntity.Datas> datases = data.datas;
        RecommendEntity.More more = data.more;
        String moreName = null == more.name ? "" : more.name;
        final String moreAction = null == more.action ? "" : more.action;
        String name = null == data.name ? "" : data.name;
        viewHolder.btn_more.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EventBus.getDefault().post((Object)moreAction);
                FireDataManager.clickMore();
            }
        });
        CardStyle2Adapter cardStyle2Adapter = new CardStyle2Adapter(this.mContext, datases);
        viewHolder.btn_more.setText((CharSequence)moreName);
        viewHolder.tv_name.setText((CharSequence)name);
        viewHolder.listview_item_gridview.setAdapter((ListAdapter)cardStyle2Adapter);
    }

    private void renderVideoStyleDefault(final ViewHolder viewHolder, final int position) {
        RecommendEntity.Data data = this.mData.get(position);
        RecommendEntity.Data2 dataEntity = data.data;
        String picUrl = null == dataEntity.pic_url ? "" : dataEntity.pic_url;
        String tv_left_up = null == dataEntity.left_up ? "" : dataEntity.left_up;
        String tv_left_down = null == dataEntity.left_down ? "" : dataEntity.left_down;
        String tv_right_down = null == dataEntity.right_down ? "" : dataEntity.right_down;
        final String vid = null == dataEntity.vid ? "" : dataEntity.vid;
        this.iid = null == dataEntity.iid ? "" : dataEntity.iid;
        boolean isContainYouKu = dataEntity.isContainYouKu;
        if (!isContainYouKu) {
            viewHolder.rl_bg.setVisibility(0);
            int childCount = viewHolder.container.getChildCount();
            if (childCount > 1) {
                viewHolder.container.removeViewAt(1);
            }
        }
        viewHolder.iv_play.setOnClickListener(new View.OnClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(View view) {
                15 var2_2 = this;
                synchronized (var2_2) {
                    if (!NetworkUtil.isWifiConnected(RecommendHomeAdapter.this.mContext)) {
                        RecommendHomeAdapter.this.mNetDialog.show();
                        RecommendHomeAdapter.this.mNetDialog.setYesOnclickListener(null, new CommonDialog.onYesOnclickListener(){

                            @Override
                            public void onYesClick() {
                                this.youkuPlay();
                            }
                        });
                    } else {
                        this.youkuPlay();
                    }
                }
            }

            private void youkuPlay() {
                RecommendHomeAdapter.this.resetDatas();
                RecommendHomeAdapter.this.setDatas(RecommendHomeAdapter.this.mData, position);
                RecommendHomeAdapter.this.notifyDataSetChanged();
                YoukuPlayerView view = RecommendHomeAdapter.this.getYoukuPlayerView();
                if (null == view) {
                    return;
                }
                viewHolder.container.addView((View)view);
                RecommendHomeAdapter.this.initPlayer(RecommendHomeAdapter.this.youkuPlayerView);
                RecommendHomeAdapter.this.youkuPlayerView.setShowBackBtn(false);
                RecommendHomeAdapter.this.youkuPlayerView.playYoukuVideo(vid);
                RecommendHomeAdapter.this.currentPlayingPosition = position;
                RecommendHomeAdapter.this.extraVid = vid;
                FireDataManager.play("recommend");
                viewHolder.rl_bg.setVisibility(4);
                EventBus.getDefault().post((Object)new BuriedPointEvent("click", RecommendHomeAdapter.this.iid, null, null, null));
            }
        });
        viewHolder.tv_left_up.setText((CharSequence)tv_left_up);
        viewHolder.tv_left_down.setText((CharSequence)tv_left_down);
        viewHolder.tv_right_down.setText((CharSequence)tv_right_down);
        Glide.with((Context)this.mContext).load((Object)picUrl).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.iv_pic);
    }

    private void initPopup(View anchorView, final int position) {
        FitPopupUtil fitPopupUtil = new FitPopupUtil((Activity)this.mContext);
        fitPopupUtil.setOnClickListener(new FitPopupUtil.OnCommitClickListener(){

            @Override
            public void onClick(String reason) {
                RecommendEntity.Data data = (RecommendEntity.Data)RecommendHomeAdapter.this.mData.get(position);
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                EventBus.getDefault().post((Object)new BuriedPointEvent("dislike", iid, null, null, null));
                EventBus.getDefault().post((Object)new DislikeEvent(position, RecommendHomeAdapter.this));
            }
        });
        fitPopupUtil.showPopup(anchorView);
    }

    public void setNotiListener(NotiListener notiListener) {
        this.mNotiListener = notiListener;
    }

    public static interface NotiListener {
        public void notifyData();
    }

    private class MyPlayerListener
    extends PlayerListener {
        private MyPlayerListener() {
        }

        public void onSeekComplete() {
            super.onSeekComplete();
        }

        public void onComplete() {
            super.onComplete();
        }

        public void onError(int code, PlayerErrorInfo info) {
            super.onError(code, info);
            new RestApiImpl().reportVid(code, RecommendHomeAdapter.this.iid);
        }

        public void OnCurrentPositionChanged(int msec) {
            super.OnCurrentPositionChanged(msec);
        }

        public void onVideoNeedPassword(int code) {
            super.onVideoNeedPassword(code);
        }
    }

    private class ViewHolder {
        private TextView tv_name;
        private TextView tv_left_up;
        private TextView tv_left_down;
        private TextView tv_right_down;
        private TextView name;
        private TextView desc;
        private TextView tvTittle;
        private TextView tvNew;
        private TextView tvDir;
        private TextView tvAct;
        private TextView mTitle;
        private TextView mSource;
        private TextView tsd_tv_stickied;
        private Button btn_more;
        private Button download;
        private ImageView pic;
        private ImageView iv_ad;
        private ImageView img_baidu_poster;
        private ImageView iv_pic;
        private ImageView iv_play;
        private ImageView mImageLeft;
        private ImageView iv_dislike;
        private ImageView mImageMid;
        private ImageView mImageRight;
        private ImageView mBigImage;
        private ImageView mRightImage;
        private ImageView logo;
        private ImageView poster;
        private LinearLayout adInfoContainer;
        private RelativeLayout rl_bg;
        private RelativeLayout rl_ad;
        private NoScrollGridView listview_item_gridview;
        private FrameLayout container;
        private NoScrollGridView gridView;
        private LinearLayout lin;
        private TextView tv_line2;
        private View tsd_article_divider;

        private ViewHolder() {
        }
    }
}

