/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.util.DensityUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.NetChangeUtil;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.firedata.sdk.Firedata;

public class TsdVideoPlayActivity
extends Activity
implements GestureDetector.OnGestureListener,
View.OnTouchListener {
    private static final String TAG = TsdVideoPlayActivity.class.getSimpleName();
    private WebView content;
    private TextView tv_title;
    private String url;
    private String title;
    private GestureDetector gestureDetector;
    private FrameLayout video_fullView;
    private View xCustomView;
    private WebChromeClient.CustomViewCallback xCustomViewCallback;
    private MyChromeClient xwebchromeclient;
    private Dialog dialog;
    private RelativeLayout rl_title;
    private TextView geture_tv_bright_percentage;
    private float mBrightness = -1.0f;
    private boolean firstScroll = false;
    private RelativeLayout gesture_bright_layout;

    @SuppressLint(value={"NewApi", "JavascriptInterface"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tsd_activity_download);
        Firedata.pageViewStart((String)"VideoPlayActivity");
        this.url = this.getIntent().getStringExtra("url");
        LogUtil.i(TAG, this.url);
        this.title = this.getIntent().getStringExtra("title");
        this.rl_title = (RelativeLayout)this.findViewById(R.id.rl_title);
        this.content = (WebView)this.findViewById(R.id.content1);
        if (Build.VERSION.SDK_INT >= 17) {
            this.content.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        this.content.loadUrl(this.url);
        this.geture_tv_bright_percentage = (TextView)this.findViewById(R.id.geture_tv_bright_percentage);
        this.gesture_bright_layout = (RelativeLayout)this.findViewById(R.id.gesture_bright_layout);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.video_fullView = (FrameLayout)this.findViewById(R.id.video_fullView);
        this.xwebchromeclient = new MyChromeClient();
        this.tv_title.setText((CharSequence)this.title);
        this.findViewById(R.id.back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                TsdVideoPlayActivity.this.finish();
            }
        });
        this.content.addJavascriptInterface((Object)new DemoJavaScriptInterface(), "demo");
        this.gestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)this);
        WebSettings webSettings = this.content.getSettings();
        String js = "javascript: var v=document.getElementsByTagName('video')[0]; v.addEventListener('playing', function() { window.demo.clickonAndroid(); }, true); ";
        webSettings.setAppCacheEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSavePassword(true);
        webSettings.setSaveFormData(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setGeolocationDatabasePath(Environment.getExternalStorageDirectory().getPath() + "html5webview");
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setSupportZoom(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        this.content.setWebChromeClient((WebChromeClient)this.xwebchromeclient);
        this.content.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                System.out.println("url=" + url);
                return false;
            }

            public void onLoadResource(WebView view, String url) {
                Log.e((String)"cache", (String)("onLoadResource-url=" + url));
                super.onLoadResource(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                TsdVideoPlayActivity.this.initNetChangePopWindows();
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void initNetChangePopWindows() {
        if (NetChangeUtil.getNetWorkType((Context)this) != 4) {
            LayoutInflater inflater = LayoutInflater.from((Context)this);
            ViewGroup nullParent = null;
            View view = inflater.inflate(R.layout.tsd_net_change_show, nullParent);
            if (this.dialog == null) {
                this.dialog = new AlertDialog.Builder((Context)this).create();
                this.dialog.show();
            }
            this.dialog.getWindow().setContentView(view);
            this.dialog.getWindow().setLayout(DensityUtil.dip2px((Context)this, 280.0f), DensityUtil.dip2px((Context)this, 125.0f));
            LinearLayout mCannel = (LinearLayout)view.findViewById(R.id.l1);
            LinearLayout mSure = (LinearLayout)view.findViewById(R.id.l2);
            mCannel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TsdVideoPlayActivity.this.dialog.dismiss();
                }
            });
            mSure.setOnClickListener(new View.OnClickListener(){

                @SuppressLint(value={"NewApi"})
                public void onClick(View v) {
                    if (Build.VERSION.SDK_INT >= 17) {
                        TsdVideoPlayActivity.this.content.getSettings().setMediaPlaybackRequiresUserGesture(false);
                    }
                    String js = "javascript: var v=document.getElementsByTagName('video')[0]; v.play(); ";
                    if (NetChangeUtil.getNetWorkType((Context)TsdVideoPlayActivity.this) == 4) {
                        TsdVideoPlayActivity.this.content.loadUrl(js);
                    }
                    TsdVideoPlayActivity.this.content.loadUrl("javascript:(function() { var videos = document.getElementsByTagName('video'); for(var i=0;i<videos.length;i++){videos[i].play();}})()");
                    TsdVideoPlayActivity.this.content.loadUrl("javascript:(function() { var videos = document.getElementsByTagName('audio'); for(var i=0;i<videos.length;i++){videos[i].play();}})()");
                    TsdVideoPlayActivity.this.dialog.dismiss();
                }
            });
        } else {
            if (Build.VERSION.SDK_INT >= 17) {
                this.content.getSettings().setMediaPlaybackRequiresUserGesture(false);
            }
            String js = "javascript: var v=document.getElementsByTagName('video')[0]; v.play(); ";
            this.content.loadUrl(js);
            this.content.loadUrl("javascript:(function() { var videos = document.getElementsByTagName('video'); for(var i=0;i<videos.length;i++){videos[i].play();}})()");
            this.content.loadUrl("javascript:(function() { var videos = document.getElementsByTagName('audio'); for(var i=0;i<videos.length;i++){videos[i].play();}})()");
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.xCustomView != null) {
            this.gestureDetector.onTouchEvent(ev);
            this.xCustomView.onTouchEvent(ev);
        }
        if (ev.getAction() == 1) {
            this.gesture_bright_layout.setVisibility(8);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean inCustomView() {
        return this.xCustomView != null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void hideCustomView() {
        this.xwebchromeclient.onHideCustomView();
        this.setRequestedOrientation(1);
        this.rl_title.setVisibility(0);
    }

    protected void onResume() {
        super.onResume();
        super.onResume();
        this.content.onResume();
        this.content.resumeTimers();
        if (this.getRequestedOrientation() != 0) {
            this.rl_title.setVisibility(0);
        }
    }

    protected void onPause() {
        super.onPause();
        this.content.onPause();
        this.content.pauseTimers();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.content.clearCache(true);
        this.video_fullView.removeAllViews();
        this.content.stopLoading();
        this.content.setWebChromeClient(null);
        this.content.setWebViewClient(null);
        this.content.destroy();
        this.content = null;
        Firedata.pageViewEnd((String)"VideoPlayActivity");
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.inCustomView()) {
                this.hideCustomView();
                return true;
            }
            this.finish();
        }
        return false;
    }

    public boolean onTouch(View arg0, MotionEvent event) {
        if (event.getAction() == 1) {
            this.gesture_bright_layout.setVisibility(8);
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent arg0) {
        this.firstScroll = true;
        return false;
    }

    public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        return false;
    }

    public void onLongPress(MotionEvent arg0) {
    }

    @SuppressLint(value={"NewApi"})
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float mOldX = e1.getX();
        float mOldY = e1.getY();
        int y = (int)e2.getRawY();
        if (this.firstScroll && !(Math.abs(distanceX) >= Math.abs(distanceY))) {
            this.gesture_bright_layout.setVisibility(0);
        }
        if (this.mBrightness < 0.0f) {
            this.mBrightness = this.getWindow().getAttributes().screenBrightness;
            if (this.mBrightness <= 0.0f) {
                this.mBrightness = 0.5f;
            }
            if (this.mBrightness < 0.01f) {
                this.mBrightness = 0.01f;
            }
        }
        Resources resources = this.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        float density1 = dm.density;
        int width3 = dm.widthPixels;
        int height3 = dm.heightPixels;
        WindowManager.LayoutParams lpa = this.getWindow().getAttributes();
        lpa.screenBrightness = this.mBrightness + (mOldY - (float)y) / (float)height3;
        if (lpa.screenBrightness > 1.0f) {
            lpa.screenBrightness = 1.0f;
        } else if (lpa.screenBrightness < 0.01f) {
            lpa.screenBrightness = 0.01f;
        }
        this.getWindow().setAttributes(lpa);
        this.geture_tv_bright_percentage.setText((CharSequence)((int)(lpa.screenBrightness * 100.0f) + "%"));
        this.firstScroll = false;
        return false;
    }

    public void onShowPress(MotionEvent arg0) {
    }

    public boolean onSingleTapUp(MotionEvent arg0) {
        return false;
    }

    private final class DemoJavaScriptInterface {
        DemoJavaScriptInterface() {
        }

        public void clickonAndroid() {
            TsdVideoPlayActivity.this.content.loadUrl("javascript: var v=document.getElementsByTagName('video')[0]; v.webkitEnterFullscreen();");
        }

        public void endonAndroid() {
        }
    }

    public class MyChromeClient
    extends WebChromeClient {
        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (TsdVideoPlayActivity.this.xCustomView != null) {
                callback.onCustomViewHidden();
                return;
            }
            TsdVideoPlayActivity.this.setRequestedOrientation(0);
            TsdVideoPlayActivity.this.rl_title.setVisibility(8);
            TsdVideoPlayActivity.this.video_fullView.setVisibility(0);
            TsdVideoPlayActivity.this.content.setVisibility(8);
            FrameLayout.LayoutParams p = new FrameLayout.LayoutParams(-1, -1);
            TsdVideoPlayActivity.this.video_fullView.addView(view, (ViewGroup.LayoutParams)p);
            TsdVideoPlayActivity.this.xCustomView = view;
            view.setLongClickable(true);
            TsdVideoPlayActivity.this.gestureDetector.setIsLongpressEnabled(true);
            view.setOnTouchListener((View.OnTouchListener)TsdVideoPlayActivity.this);
            TsdVideoPlayActivity.this.xCustomViewCallback = callback;
        }

        public void onHideCustomView() {
            if (TsdVideoPlayActivity.this.xCustomView == null) {
                return;
            }
            TsdVideoPlayActivity.this.video_fullView.setVisibility(8);
            TsdVideoPlayActivity.this.content.setVisibility(0);
            TsdVideoPlayActivity.this.video_fullView.removeAllViews();
            TsdVideoPlayActivity.this.xCustomView = null;
            TsdVideoPlayActivity.this.xCustomViewCallback.onCustomViewHidden();
            TsdVideoPlayActivity.this.rl_title.setVisibility(0);
            TsdVideoPlayActivity.this.setRequestedOrientation(1);
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Log.d((String)"ZR", (String)(consoleMessage.message() + " at " + consoleMessage.sourceId() + ":" + consoleMessage.lineNumber()));
            return super.onConsoleMessage(consoleMessage);
        }
    }
}

