/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import com.youku.cloud.module.PlayerErrorInfo;
import com.youku.cloud.player.PlayerListener;
import com.youku.cloud.player.VideoDefinition;
import com.youku.cloud.player.YoukuPlayerView;
import com.youku.cloud.player.YoukuUIListener;

public class TsdVideoFullscreenActivity
extends Activity {
    private Context mContext;
    private String vid;
    private String iid;
    private YoukuPlayerView youkuPlayerView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tsd_activity_video_fullscreen);
        this.mContext = this;
        this.initData();
        this.youkuPlayerView = (YoukuPlayerView)this.findViewById(R.id.baseview);
        this.youkuPlayerView.attachActivity((Activity)this);
        this.youkuPlayerView.setPreferVideoDefinition(VideoDefinition.VIDEO_HD);
        this.youkuPlayerView.setPlayerListener((PlayerListener)new MyPlayerListener());
        this.youkuPlayerView.playYoukuVideo(this.vid);
        this.youkuPlayerView.goFullScreen();
        this.youkuPlayerView.setUIListener(new YoukuUIListener(){

            public void onBackBtnClick() {
                TsdVideoFullscreenActivity.this.finish();
            }

            public void onFullBtnClick() {
            }
        });
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.vid = intent.getStringExtra("vid");
        this.iid = intent.getStringExtra("iid");
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.youkuPlayerView.release();
        this.finish();
    }

    protected void onPause() {
        super.onPause();
        if (null != this.youkuPlayerView) {
            this.youkuPlayerView.onPause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (null != this.youkuPlayerView) {
            this.youkuPlayerView.playYoukuVideo(this.vid);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.youkuPlayerView.onDestroy();
    }

    private class MyPlayerListener
    extends PlayerListener {
        private MyPlayerListener() {
        }

        public void onComplete() {
            super.onComplete();
        }

        public void onTimeout() {
            super.onTimeout();
            Toast.makeText((Context)TsdVideoFullscreenActivity.this.mContext, (CharSequence)"onTimeout", (int)0).show();
        }

        public void onError(int code, PlayerErrorInfo info) {
            super.onError(code, info);
            new RestApiImpl().reportVid(code, TsdVideoFullscreenActivity.this.iid);
            LogUtil.i("MainActivity", "code" + code + "info" + info.getDesc());
        }

        public void OnCurrentPositionChanged(int msec) {
            super.OnCurrentPositionChanged(msec);
        }

        public void onVideoNeedPassword(int code) {
            super.onVideoNeedPassword(code);
        }
    }
}

