package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.support.design.widget.TabLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;

import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdChoiceLikeActivity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;

import static ai.botbrain.ttcloud.sdk.TsdConstant.PREF_CHANNEL;
import static ai.botbrain.ttcloud.sdk.util.GsonUtil.GsonToBean;


/**
 * Description：
 * Creator: Created by peter.
 * Date: 2017/8/13.
 */

public class TsdTabLayout extends TabLayout implements TabLayout.OnTabSelectedListener {

    private boolean isInitTop;
    private List<String> label_idList;

    private String cache_title;

    private Context mContext;
    private TopTitleEntity topTitleEntity;
    private RenderListener mRenderListener;

    private static final String VERSION_KEY = "version_key";

    private ArrayList<String> tabTitleArray;

    public TsdTabLayout(Context context) {
        super(context);
        init(context);
    }

    public TsdTabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public TsdTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private String feedType;

    private void setDayTheme() {
        feedType = (String) TsdSPUtils.get(mContext, TsdConstant.FEED_TYPE, TsdConstant.TYPE_ARTICLE);
        setSelectedTabIndicatorColor(getResources().getColor(R.color.tpp_color_187cdc));
        setTabTextColors(getResources().getColor(R.color.tsd_color_222222), getResources().getColor(R.color.tpp_color_187cdc));
        setBackgroundColor(mContext.getResources().getColor(R.color.tsd_color_f4f5f6));
    }

    private void setNightTheme() {
        setBackgroundColor(mContext.getResources().getColor(R.color.tsd_color_252525));
        setSelectedTabIndicatorColor(getResources().getColor(R.color.tsd_color_707070));
        setTabTextColors(getResources().getColor(R.color.tsd_color_707070), getResources().getColor(R.color.tpp_color_187cdc));
    }

    private void initTheme() {
        if (TtCloudManager.getCurrentTheme() == 0) {
            setDayTheme();
        } else {
            setNightTheme();
        }
    }

    public void init(Context context) {
        mContext = context;
        label_idList = new ArrayList<>();
        addOnTabSelectedListener(this);
        setTabMode(MODE_SCROLLABLE);
        initTheme();
        cache_title = (String) TsdSPUtils.get(context, PREF_CHANNEL + feedType, "");

        if (checkCacheDataValid(cache_title)) {
            renderConfig(cache_title);
        } else {
            TsdSPUtils.remove(context, PREF_CHANNEL + feedType);
        }
        new RestApiImpl().getConfig(new ConfigObserver(), feedType);
    }

    private boolean checkCacheDataValid(String cache) {
        if (TextUtils.isEmpty(cache))
            return false;
        TopTitleEntity entity = GsonUtil.GsonToBean(cache, TopTitleEntity.class);
        if (null==entity)
            return false;
        return true;
    }

    @Override
    public void onTabSelected(Tab tab) {
        int position = tab.getPosition();
        String text = (String) tab.getText();
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return;
        }
        if (null == topTitleEntity.data.columns)
            return;
        if (position >= topTitleEntity.data.columns.size())
            return;
        String label_id = topTitleEntity.data.columns.get(position).id;

        if (!TextUtils.isEmpty(text)) {
            Firedata.pageViewEnd(text);
        }
        Firedata.pageViewStart(label_id);
    }

    @Override
    public void onTabUnselected(Tab tab) {

    }

    @Override
    public void onTabReselected(Tab tab) {

    }

    private final class ConfigObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            if (null != mRenderListener && TextUtils.isEmpty(cache_title)) {
                mRenderListener.renderTabLayoutFail();
            }
        }

        @Override
        public void onSuccess(Response<String> response) {
            String s = response.body();
            //mLoadingView.notifyDataChanged(LoadingView.State.done);
            renderConfig(s);
        }
    }

    private void renderConfig(String response) {
        if (TextUtils.isEmpty(response)) {
            return;
        }

        cache(response);
        try {
            topTitleEntity = GsonToBean(response, TopTitleEntity.class);
            coldStart(topTitleEntity);
            tabTitleArray = getTabTitleArray(topTitleEntity);
            initTabLayout();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void coldStart(TopTitleEntity topTitleEntity) {
        TopTitleEntity.Data data = topTitleEntity.data;
        if (null == data.coldStart) return;
        TopTitleEntity.ColdStart coldStart = data.coldStart;
        String appName = null == topTitleEntity.appName ? "" : topTitleEntity.appName;

        String enable = null == coldStart.enable ? "" : coldStart.enable;

        if (enable.equals("on") && isFirstLauncher()) {
            Intent intent = new Intent();
            intent.setClass(mContext, TsdChoiceLikeActivity.class);
            intent.putExtra("ACTION_COLDSTART", coldStart);
            intent.putExtra("ACTION_APP_NAME", appName);
            mContext.startActivity(intent);
        }

    }

    private String appName;

    private synchronized void initTabLayout() {
        removeAllTabs();
        for (int i = 0; i < tabTitleArray.size(); i++) {
            String tab = tabTitleArray.get(i);
            addTab(newTab().setText(tab));
        }
    }

    private ArrayList<String> getTabTitleArray(TopTitleEntity topTitleEntity) {
        label_idList.clear();
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return null;
        }
        tabTitleArray = new ArrayList<>();
        appName = topTitleEntity.appName;
        if (null != mRenderListener) {
            mRenderListener.renderTabLayoutSuccess(topTitleEntity.data, appName);
        }
        List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        if (null == datas || datas.size() == 0) return null;
        for (TopTitleEntity.Columns data : datas) {
            String label_name = data.name;
            String label_id = data.id;
            tabTitleArray.add(label_name);
            label_idList.add(label_id);
        }

        return tabTitleArray;
    }

    private boolean isFirstLauncher() {
        int currentVersion = getAppVersionCode(TsdContextHolder.getContext());
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(TsdContextHolder.getContext());
        int lastVersion = prefs.getInt(VERSION_KEY, 0);
        if (currentVersion > lastVersion) {
            prefs.edit().putInt(VERSION_KEY, currentVersion).apply();
            return true;
        }
        return false;
    }

    private static int versionName;

    public void onResume() {
        initTheme();
    }

    /**
     * 返回当前程序版本名
     */
    public static int getAppVersionCode(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        } catch (Exception e) {
            Log.e("VersionInfo", "Exception", e);
        }
        return versionName;
    }

    public interface RenderListener {
        void renderTabLayoutSuccess(TopTitleEntity.Data data, String appName);

        void renderTabLayoutFail();
    }

    public void setCallBack(RenderListener listener) {
        mRenderListener = listener;
        if (null != topTitleEntity)
            mRenderListener.renderTabLayoutSuccess(topTitleEntity.data, appName);
    }

    private void cache(String response) {
        TsdSPUtils.put(mContext, PREF_CHANNEL + feedType, response);
    }

    public void retryRender() {
        new RestApiImpl().getConfig(new ConfigObserver(), feedType);
    }
}
