package ai.botbrain.ttcloud.sdk.util;


import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.Toast;


public class NetChangeUtil {
	
	/** 没有网络 */
	public static final int NETWORKTYPE_INVALID = 0;
	/** wap网络 */
	public static final int NETWORKTYPE_WAP = 1;
	/** 2G网络 */
	public static final int NETWORKTYPE_2G = 2;
	/** 3G和3G以上网络，或统称为快速网络 */
	public static final int NETWORKTYPE_3G = 3;
	/** wifi网络 */
	public static final int NETWORKTYPE_WIFI = 4;
	public static  int mNetWorkType;
	
	
	 public static int getNetWorkType(Context context) {
		 
		 ConnectivityManager manager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
		 NetworkInfo networkInfo = manager.getActiveNetworkInfo();
		 if(networkInfo==null){
			 Toast.makeText(context, "网络未连接", Toast.LENGTH_SHORT).show();
		 }
		 if(networkInfo!=null){
		 String type = networkInfo.getTypeName();
		
		 
		   if (networkInfo != null && networkInfo.isConnected()) {
			   if (type!=null&&type.equalsIgnoreCase("WIFI")) {
					 mNetWorkType = NETWORKTYPE_WIFI;
				}else if (type!=null&&type.equalsIgnoreCase("MOBILE")) {
					  String proxyHost = android.net.Proxy.getDefaultHost();
		                mNetWorkType = TextUtils.isEmpty(proxyHost)
		                        ? (isFastMobileNetwork(context) ? NETWORKTYPE_3G : NETWORKTYPE_2G)
		                        : NETWORKTYPE_WAP;
				}
		   }
		 }
		return mNetWorkType;
	 }
	 
	 
	 public  static boolean isFastMobileNetwork(Context context) {
	 TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService(Context.TELEPHONY_SERVICE);
	     switch (telephonyManager.getNetworkType()) {
	         case TelephonyManager.NETWORK_TYPE_1xRTT:
	             return false; // ~ 50-100 kbps
	         case TelephonyManager.NETWORK_TYPE_CDMA:
	             return false; // ~ 14-64 kbps
	         case TelephonyManager.NETWORK_TYPE_EDGE:
	             return false; // ~ 50-100 kbps
	         case TelephonyManager.NETWORK_TYPE_EVDO_0:
	             return true; // ~ 400-1000 kbps
	         case TelephonyManager.NETWORK_TYPE_EVDO_A:
	             return true; // ~ 600-1400 kbps
	         case TelephonyManager.NETWORK_TYPE_GPRS:
	             return false; // ~ 100 kbps
	         case TelephonyManager.NETWORK_TYPE_HSDPA:
	             return true; // ~ 2-14 Mbps
	         case TelephonyManager.NETWORK_TYPE_HSPA:
	             return true; // ~ 700-1700 kbps
	         case TelephonyManager.NETWORK_TYPE_HSUPA:
	             return true; // ~ 1-23 Mbps
	         case TelephonyManager.NETWORK_TYPE_UMTS:
	             return true; // ~ 400-7000 kbps
	         case TelephonyManager.NETWORK_TYPE_EHRPD:
	             return true; // ~ 1-2 Mbps
	         case TelephonyManager.NETWORK_TYPE_EVDO_B:
	             return true; // ~ 5 Mbps
	         case TelephonyManager.NETWORK_TYPE_HSPAP:
	             return true; // ~ 10-20 Mbps
	         case TelephonyManager.NETWORK_TYPE_IDEN:
	             return false; // ~25 kbps
	         case TelephonyManager.NETWORK_TYPE_LTE:
	             return true; // ~ 10+ Mbps
	         case TelephonyManager.NETWORK_TYPE_UNKNOWN:
	             return false;
	         default:
	             return false;
	         }
	     }

}
