package ai.botbrain.ttcloud.sdk.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.MovieListEntity;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TsdTvAdapter_Search extends BaseAdapter {

    private Context mContext;

    private List<MovieListEntity.Episodes> episodesList;
    private MovieListEntity.Data mData;

    private String channel;
    private String iid;

    public TsdTvAdapter_Search(Context context, MovieListEntity.Data data) {
        this.episodesList = data.episodes;
        this.mContext = context;
        this.mData = data;
        this.channel = data.channel;
        this.iid = data.iid;
    }

    @Override
    public int getCount() {
        return null == episodesList ? 0 : episodesList.size();
    }

    @Override
    public Object getItem(int position) {
        return episodesList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        final ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate(mContext, R.layout.tsd_item_tv, null);
            viewHolder.btnNum = (Button) convertView.findViewById(R.id.btn_num);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        final MovieListEntity.Episodes entity = episodesList.get(position);
        final String num_text = getbtnNumText(entity);
        final boolean is_free = entity.sources.get(0).is_free;

        viewHolder.btnNum.setText(num_text);
        if (is_free) {
            viewHolder.btnNum.setTextColor(mContext.getResources().getColor(R.color.tsd_black));
        } else {
            viewHolder.btnNum.setTextColor(mContext.getResources().getColor(R.color.tsd_gray));
        }

        viewHolder.btnNum.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                FireDataManager.clickCsn(channel, mData.title, iid, num_text);
                final Handler mainHandler = new Handler(Looper.getMainLooper());
                if (episodesList.get(position).sources.get(0).is_free) {
                    notifyDataSetChanged();
                    final String url = episodesList.get(position).sources.get(0).url;
                    //commentToService(mData, "click", num_text);
                    // TODO 埋点
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread() {
                            @Override
                            public void run() {
                                super.run();
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                mainHandler.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        FireDataManager.play(mData.channel);
                                        JsPresenter.getInstance().StartPlayback(mContext, url, mData.title, iid);
                                    }
                                });
                            }
                        }.start();
                    } else {
                        FireDataManager.play(mData.channel);
                        JsPresenter.getInstance().StartPlayback(mContext, url, mData.title, iid);
                    }
                }
            }
        });
        return convertView;
    }

    private class ViewHolder {
        private Button btnNum;
    }

    private String getbtnNumText(MovieListEntity.Episodes entity) {
        String s;
        if (!channel.equals("综艺")) {
            s = entity.episode;
        } else {
            String text = entity.episode;
            String str1 = text.substring(0, 4);
            String str2 = text.substring(4, 6);
            String str3 = text.substring(6, 8);
            s = str1 + "-" + str2 + "-" + str3;
        }
        return s;
    }

}
