package ai.botbrain.ttcloud.sdk.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.ClickCategoryEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class SecondaryDirectoryAdapter extends BaseAdapter {

    private Context mContext;

    private List<TopTitleEntity.SubColumns> mDatas;
    private ClickCategoryEvent categoryEvent;

    public SecondaryDirectoryAdapter(Context context, List<TopTitleEntity.SubColumns> datas) {
        super();
        this.mContext = context;
        this.mDatas = datas;
        categoryEvent = new ClickCategoryEvent();
    }

    @Override
    public int getCount() {
        return null == mDatas ? 0 : mDatas.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = View.inflate(mContext, R.layout.tsd_gridview_item, null);
            holder.button = (TextView) convertView.findViewById(R.id.gridview_item_button);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        final TopTitleEntity.SubColumns labelData = mDatas.get(position);
        boolean isSelected = labelData.isSelected;

        if (isSelected)
            holder.button.setBackgroundColor(Color.parseColor("#E5E5E5"));
        holder.button.setText(labelData.name);

        holder.button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                categoryEvent.position = position;
                EventBus.getDefault().post(categoryEvent);
                FireDataManager.sec_cat_click(labelData);
            }
        });

        return convertView;
    }

    private class ViewHolder {
        TextView button;
    }

}
